%------------------------------------------------------------------------------
% File     : ITP003^4 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2Earithmetic_2EMOD__2.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Earithmetic_2EMOD__2.p [Gau20]
%          : HL401001^4.p [TPAP]

% Status   : Theorem
% Rating   : 0.89 v9.1.0, 0.88 v9.0.0, 0.90 v8.2.0, 0.92 v8.1.0, 0.82 v7.5.0
% Syntax   : Number of formulae    : 3527 (1238 unt;1357 typ;   0 def)
%            Number of atoms       : 4814 (2051 equ; 213 cnn)
%            Maximal formula atoms :   30 (   2 avg)
%            Number of connectives : 67428 ( 213   ~; 230   |; 665   &;64825   @)
%                                         ( 626 <=>; 869  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   41 (   7 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  : 2358 (2358   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :  594 ( 592 usr; 206 con; 0-4 aty)
%            Number of variables   : 7067 (   0   ^;6869   !; 198   ?;7067   :)
% SPC      : TH0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002^4.ax').
include('Axioms/ITP001/ITP003^4.ax').
include('Axioms/ITP001/ITP004^4.ax').
include('Axioms/ITP001/ITP005^4.ax').
include('Axioms/ITP001/ITP006^4.ax').
include('Axioms/ITP001/ITP007^4.ax').
include('Axioms/ITP001/ITP008^4.ax').
include('Axioms/ITP001/ITP009^4.ax').
include('Axioms/ITP001/ITP010^4.ax').
include('Axioms/ITP001/ITP011^4.ax').
include('Axioms/ITP001/ITP012^4.ax').
include('Axioms/ITP001/ITP013^4.ax').
include('Axioms/ITP001/ITP014^4.ax').
include('Axioms/ITP001/ITP015^4.ax').
%------------------------------------------------------------------------------
thf(u,type,
    u: $tType ).

thf(d,type,
    d: $tType ).

thf(du,type,
    du: $tType ).

thf(mono_2Etyop_2Enum_2Enum,type,
    mono_2Etyop_2Enum_2Enum: $tType ).

thf(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: d ).

thf(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: d > d > d ).

thf(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: d ).

thf(s,type,
    s: d > u > du ).

thf(app_2E2,type,
    app_2E2: du > du > u ).

thf(combin_i_2E0,type,
    combin_i_2E0: u ).

thf(combin_k_2E0,type,
    combin_k_2E0: u ).

thf(combin_s_2E0,type,
    combin_s_2E0: u ).

thf(c_2Ebool_2E_21_2E0,type,
    c_2Ebool_2E_21_2E0: u ).

thf(c_2Ebool_2E_21_2E1,type,
    c_2Ebool_2E_21_2E1: du > u ).

thf(c_2Earithmetic_2E_2A_2E0,type,
    c_2Earithmetic_2E_2A_2E0: u ).

thf(c_2Earithmetic_2E_2A_2E2,type,
    c_2Earithmetic_2E_2A_2E2: du > du > u ).

thf(c_2Earithmetic_2E_2B_2E0,type,
    c_2Earithmetic_2E_2B_2E0: u ).

thf(c_2Earithmetic_2E_2B_2E2,type,
    c_2Earithmetic_2E_2B_2E2: du > du > u ).

thf(c_2Earithmetic_2E_2D_2E0,type,
    c_2Earithmetic_2E_2D_2E0: u ).

thf(c_2Earithmetic_2E_2D_2E2,type,
    c_2Earithmetic_2E_2D_2E2: du > du > u ).

thf(c_2Ebool_2E_2F_5C_2E0,type,
    c_2Ebool_2E_2F_5C_2E0: u ).

thf(c_2Ebool_2E_2F_5C_2E2,type,
    c_2Ebool_2E_2F_5C_2E2: du > du > u ).

thf(c_2Enum_2E0_2E0,type,
    c_2Enum_2E0_2E0: u ).

thf(c_2Eprim__rec_2E_3C_2E0,type,
    c_2Eprim__rec_2E_3C_2E0: u ).

thf(c_2Eprim__rec_2E_3C_2E2,type,
    c_2Eprim__rec_2E_3C_2E2: du > du > u ).

thf(c_2Earithmetic_2E_3C_3D_2E0,type,
    c_2Earithmetic_2E_3C_3D_2E0: u ).

thf(c_2Earithmetic_2E_3C_3D_2E2,type,
    c_2Earithmetic_2E_3C_3D_2E2: du > du > u ).

thf(c_2Emin_2E_3D_2E0,type,
    c_2Emin_2E_3D_2E0: u ).

thf(c_2Emin_2E_3D_2E2,type,
    c_2Emin_2E_3D_2E2: du > du > u ).

thf(c_2Emin_2E_3D_3D_3E_2E0,type,
    c_2Emin_2E_3D_3D_3E_2E0: u ).

thf(c_2Emin_2E_3D_3D_3E_2E2,type,
    c_2Emin_2E_3D_3D_3E_2E2: du > du > u ).

thf(c_2Earithmetic_2E_3E_2E0,type,
    c_2Earithmetic_2E_3E_2E0: u ).

thf(c_2Earithmetic_2E_3E_2E2,type,
    c_2Earithmetic_2E_3E_2E2: du > du > u ).

thf(c_2Earithmetic_2E_3E_3D_2E0,type,
    c_2Earithmetic_2E_3E_3D_2E0: u ).

thf(c_2Earithmetic_2E_3E_3D_2E2,type,
    c_2Earithmetic_2E_3E_3D_2E2: du > du > u ).

thf(c_2Ebool_2E_3F_2E0,type,
    c_2Ebool_2E_3F_2E0: u ).

thf(c_2Ebool_2E_3F_2E1,type,
    c_2Ebool_2E_3F_2E1: du > u ).

thf(c_2Earithmetic_2EABS__DIFF_2E0,type,
    c_2Earithmetic_2EABS__DIFF_2E0: u ).

thf(c_2Earithmetic_2EABS__DIFF_2E2,type,
    c_2Earithmetic_2EABS__DIFF_2E2: du > du > u ).

thf(c_2Earithmetic_2EBIT1_2E0,type,
    c_2Earithmetic_2EBIT1_2E0: u ).

thf(c_2Earithmetic_2EBIT1_2E1,type,
    c_2Earithmetic_2EBIT1_2E1: du > u ).

thf(c_2Earithmetic_2EBIT2_2E0,type,
    c_2Earithmetic_2EBIT2_2E0: u ).

thf(c_2Earithmetic_2EBIT2_2E1,type,
    c_2Earithmetic_2EBIT2_2E1: du > u ).

thf(c_2Ebool_2ECOND_2E0,type,
    c_2Ebool_2ECOND_2E0: u ).

thf(c_2Ebool_2ECOND_2E3,type,
    c_2Ebool_2ECOND_2E3: du > du > du > u ).

thf(c_2Earithmetic_2EDIV_2E0,type,
    c_2Earithmetic_2EDIV_2E0: u ).

thf(c_2Earithmetic_2EDIV_2E2,type,
    c_2Earithmetic_2EDIV_2E2: du > du > u ).

thf(c_2Earithmetic_2EDIV2_2E0,type,
    c_2Earithmetic_2EDIV2_2E0: u ).

thf(c_2Earithmetic_2EDIV2_2E1,type,
    c_2Earithmetic_2EDIV2_2E1: du > u ).

thf(c_2Earithmetic_2EEVEN_2E0,type,
    c_2Earithmetic_2EEVEN_2E0: u ).

thf(c_2Earithmetic_2EEVEN_2E1,type,
    c_2Earithmetic_2EEVEN_2E1: du > u ).

thf(c_2Earithmetic_2EEXP_2E0,type,
    c_2Earithmetic_2EEXP_2E0: u ).

thf(c_2Earithmetic_2EEXP_2E2,type,
    c_2Earithmetic_2EEXP_2E2: du > du > u ).

thf(c_2Ebool_2EF_2E0,type,
    c_2Ebool_2EF_2E0: u ).

thf(c_2Earithmetic_2EFACT_2E0,type,
    c_2Earithmetic_2EFACT_2E0: u ).

thf(c_2Earithmetic_2EFACT_2E1,type,
    c_2Earithmetic_2EFACT_2E1: du > u ).

thf(c_2Earithmetic_2EFUNPOW_2E0,type,
    c_2Earithmetic_2EFUNPOW_2E0: u ).

thf(c_2Earithmetic_2EFUNPOW_2E3,type,
    c_2Earithmetic_2EFUNPOW_2E3: du > du > du > u ).

thf(c_2Earithmetic_2EMAX_2E0,type,
    c_2Earithmetic_2EMAX_2E0: u ).

thf(c_2Earithmetic_2EMAX_2E2,type,
    c_2Earithmetic_2EMAX_2E2: du > du > u ).

thf(c_2Earithmetic_2EMIN_2E0,type,
    c_2Earithmetic_2EMIN_2E0: u ).

thf(c_2Earithmetic_2EMIN_2E2,type,
    c_2Earithmetic_2EMIN_2E2: du > du > u ).

thf(c_2Earithmetic_2EMOD_2E0,type,
    c_2Earithmetic_2EMOD_2E0: u ).

thf(c_2Earithmetic_2EMOD_2E2,type,
    c_2Earithmetic_2EMOD_2E2: du > du > u ).

thf(c_2Earithmetic_2ENRC_2E0,type,
    c_2Earithmetic_2ENRC_2E0: u ).

thf(c_2Earithmetic_2ENRC_2E4,type,
    c_2Earithmetic_2ENRC_2E4: du > du > du > du > u ).

thf(c_2Earithmetic_2ENUMERAL_2E0,type,
    c_2Earithmetic_2ENUMERAL_2E0: u ).

thf(c_2Earithmetic_2ENUMERAL_2E1,type,
    c_2Earithmetic_2ENUMERAL_2E1: du > u ).

thf(c_2Earithmetic_2EODD_2E0,type,
    c_2Earithmetic_2EODD_2E0: u ).

thf(c_2Earithmetic_2EODD_2E1,type,
    c_2Earithmetic_2EODD_2E1: du > u ).

thf(c_2Ebool_2EONE__ONE_2E0,type,
    c_2Ebool_2EONE__ONE_2E0: u ).

thf(c_2Ebool_2EONE__ONE_2E1,type,
    c_2Ebool_2EONE__ONE_2E1: du > u ).

thf(c_2Eprim__rec_2EPRE_2E0,type,
    c_2Eprim__rec_2EPRE_2E0: u ).

thf(c_2Eprim__rec_2EPRE_2E1,type,
    c_2Eprim__rec_2EPRE_2E1: du > u ).

thf(c_2Erelation_2ERTC_2E0,type,
    c_2Erelation_2ERTC_2E0: u ).

thf(c_2Erelation_2ERTC_2E1,type,
    c_2Erelation_2ERTC_2E1: du > u ).

thf(c_2Erelation_2ERTC_2E3,type,
    c_2Erelation_2ERTC_2E3: du > du > du > u ).

thf(c_2Enum_2ESUC_2E0,type,
    c_2Enum_2ESUC_2E0: u ).

thf(c_2Enum_2ESUC_2E1,type,
    c_2Enum_2ESUC_2E1: du > u ).

thf(c_2Ebool_2ET_2E0,type,
    c_2Ebool_2ET_2E0: u ).

thf(c_2Erelation_2ETC_2E0,type,
    c_2Erelation_2ETC_2E0: u ).

thf(c_2Erelation_2ETC_2E3,type,
    c_2Erelation_2ETC_2E3: du > du > du > u ).

thf(c_2Earithmetic_2EZERO_2E0,type,
    c_2Earithmetic_2EZERO_2E0: u ).

thf(c_2Ebool_2E_5C_2F_2E0,type,
    c_2Ebool_2E_5C_2F_2E0: u ).

thf(c_2Ebool_2E_5C_2F_2E2,type,
    c_2Ebool_2E_5C_2F_2E2: du > du > u ).

thf(c_2Eprim__rec_2Emeasure_2E0,type,
    c_2Eprim__rec_2Emeasure_2E0: u ).

thf(c_2Eprim__rec_2Emeasure_2E1,type,
    c_2Eprim__rec_2Emeasure_2E1: du > u ).

thf(c_2Earithmetic_2Enat__elim____magic_2E0,type,
    c_2Earithmetic_2Enat__elim____magic_2E0: u ).

thf(c_2Earithmetic_2Enat__elim____magic_2E1,type,
    c_2Earithmetic_2Enat__elim____magic_2E1: du > u ).

thf(c_2Earithmetic_2Enum__CASE_2E0,type,
    c_2Earithmetic_2Enum__CASE_2E0: u ).

thf(c_2Earithmetic_2Enum__CASE_2E3,type,
    c_2Earithmetic_2Enum__CASE_2E3: du > du > du > u ).

thf(c_2Erelation_2Etransitive_2E0,type,
    c_2Erelation_2Etransitive_2E0: u ).

thf(c_2Erelation_2Etransitive_2E1,type,
    c_2Erelation_2Etransitive_2E1: du > u ).

thf(c_2Ebool_2E_7E_2E0,type,
    c_2Ebool_2E_7E_2E0: u ).

thf(c_2Ebool_2E_7E_2E1,type,
    c_2Ebool_2E_7E_2E1: du > u ).

thf(mono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool: ( $o > $o ) > $o > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: ( $o > $o > $o ) > $o > $o > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    mono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: ( $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool: ( ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o ) > ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    mono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: ( ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool: ( ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o ) > ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,type,
    mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool: ( mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2E_2A,type,
    mono_2Ec_2Earithmetic_2E_2A: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2E_2B,type,
    mono_2Ec_2Earithmetic_2E_2B: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2E_2D,type,
    mono_2Ec_2Earithmetic_2E_2D: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Ebool_2E_2F_5C,type,
    mono_2Ec_2Ebool_2E_2F_5C: $o > $o > $o ).

thf(mono_2Ec_2Enum_2E0,type,
    mono_2Ec_2Enum_2E0: mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Eprim__rec_2E_3C,type,
    mono_2Ec_2Eprim__rec_2E_3C: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Earithmetic_2E_3C_3D,type,
    mono_2Ec_2Earithmetic_2E_3C_3D: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Emin_2E_3D_3D_3E,type,
    mono_2Ec_2Emin_2E_3D_3D_3E: $o > $o > $o ).

thf(mono_2Ec_2Earithmetic_2E_3E,type,
    mono_2Ec_2Earithmetic_2E_3E: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Earithmetic_2E_3E_3D,type,
    mono_2Ec_2Earithmetic_2E_3E_3D: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Earithmetic_2EABS__DIFF,type,
    mono_2Ec_2Earithmetic_2EABS__DIFF: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EBIT1,type,
    mono_2Ec_2Earithmetic_2EBIT1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EBIT2,type,
    mono_2Ec_2Earithmetic_2EBIT2: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum: $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EDIV,type,
    mono_2Ec_2Earithmetic_2EDIV: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EDIV2,type,
    mono_2Ec_2Earithmetic_2EDIV2: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EEVEN,type,
    mono_2Ec_2Earithmetic_2EEVEN: mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Earithmetic_2EEXP,type,
    mono_2Ec_2Earithmetic_2EEXP: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Ebool_2EF,type,
    mono_2Ec_2Ebool_2EF: $o ).

thf(mono_2Ec_2Earithmetic_2EFACT,type,
    mono_2Ec_2Earithmetic_2EFACT: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EMAX,type,
    mono_2Ec_2Earithmetic_2EMAX: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EMIN,type,
    mono_2Ec_2Earithmetic_2EMIN: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EMOD,type,
    mono_2Ec_2Earithmetic_2EMOD: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2ENUMERAL,type,
    mono_2Ec_2Earithmetic_2ENUMERAL: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Earithmetic_2EODD,type,
    mono_2Ec_2Earithmetic_2EODD: mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o ).

thf(mono_2Ec_2Eprim__rec_2EPRE,type,
    mono_2Ec_2Eprim__rec_2EPRE: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Erelation_2ERTC_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Erelation_2ERTC_2Emono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(mono_2Ec_2Enum_2ESUC,type,
    mono_2Ec_2Enum_2ESUC: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Ebool_2ET,type,
    mono_2Ec_2Ebool_2ET: $o ).

thf(mono_2Ec_2Earithmetic_2EZERO,type,
    mono_2Ec_2Earithmetic_2EZERO: mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Ebool_2E_5C_2F,type,
    mono_2Ec_2Ebool_2E_5C_2F: $o > $o > $o ).

thf(mono_2Ec_2Earithmetic_2Enat__elim____magic,type,
    mono_2Ec_2Earithmetic_2Enat__elim____magic: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(mono_2Ec_2Erelation_2Etransitive_2Emono_2Etyop_2Enum_2Enum,type,
    mono_2Ec_2Erelation_2Etransitive_2Emono_2Etyop_2Enum_2Enum: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o ).

thf(mono_2Ec_2Ebool_2E_7E,type,
    mono_2Ec_2Ebool_2E_7E: $o > $o ).

thf(i_mono_2Etyop_2Emin_2Ebool,type,
    i_mono_2Etyop_2Emin_2Ebool: $o > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: ( $o > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: ( $o > $o > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: ( $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: ( ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29: ( ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: ( ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: ( mono_2Etyop_2Enum_2Enum > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > u ).

thf(i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > u ).

thf(i_mono_2Etyop_2Enum_2Enum,type,
    i_mono_2Etyop_2Enum_2Enum: mono_2Etyop_2Enum_2Enum > u ).

thf(j_mono_2Etyop_2Emin_2Ebool,type,
    j_mono_2Etyop_2Emin_2Ebool: du > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29: du > $o > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29: du > $o > $o > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29: du > $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29: du > ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29: du > ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29: du > ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29: du > mono_2Etyop_2Enum_2Enum > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29: du > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29: du > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,type,
    j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29: du > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ).

thf(j_mono_2Etyop_2Enum_2Enum,type,
    j_mono_2Etyop_2Enum_2Enum: du > mono_2Etyop_2Enum_2Enum ).

thf(reserved_2Eho_2Eeq__ext,axiom,
    ! [A_27a: d,A_27b: d,V0f_2E0: u,V1g_2E0: u] :
      ( ! [V2x_2E0: u] :
          ( ( s @ A_27b @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ V0f_2E0 ) @ ( s @ A_27a @ V2x_2E0 ) ) )
          = ( s @ A_27b @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ V1g_2E0 ) @ ( s @ A_27a @ V2x_2E0 ) ) ) )
     => ( ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ V0f_2E0 )
        = ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ V1g_2E0 ) ) ) ).

thf(reserved_2Eho_2Ei__thm,axiom,
    ! [A_27a: d,V0x_2E0: u] :
      ( ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ combin_i_2E0 ) @ ( s @ A_27a @ V0x_2E0 ) ) )
      = ( s @ A_27a @ V0x_2E0 ) ) ).

thf(reserved_2Eho_2Ek__thm,axiom,
    ! [A_27a: d,A_27b: d,V0x_2E0: u,V1y_2E0: u] :
      ( ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27b @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27b @ A_27a ) ) @ combin_k_2E0 ) @ ( s @ A_27a @ V0x_2E0 ) ) ) @ ( s @ A_27b @ V1y_2E0 ) ) )
      = ( s @ A_27a @ V0x_2E0 ) ) ).

thf(reserved_2Eho_2Es__thm,axiom,
    ! [A_27a: d,A_27b: d,A_27c: d,V0f_2E0: u,V1g_2E0: u,V2x_2E0: u] :
      ( ( s @ A_27c @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27c ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ ( tyop_2Emin_2Efun @ A_27a @ A_27c ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27b @ A_27c ) ) @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ ( tyop_2Emin_2Efun @ A_27a @ A_27c ) ) ) @ combin_s_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27b @ A_27c ) ) @ V0f_2E0 ) ) ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ V1g_2E0 ) ) ) @ ( s @ A_27a @ V2x_2E0 ) ) )
      = ( s @ A_27c @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27b @ A_27c ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27b @ A_27c ) ) @ V0f_2E0 ) @ ( s @ A_27a @ V2x_2E0 ) ) ) @ ( s @ A_27b @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27b ) @ V1g_2E0 ) @ ( s @ A_27a @ V2x_2E0 ) ) ) ) ) ) ).

thf(reserved_2Elogic_2E_2F_5C,axiom,
    ! [V0: $o,V1: $o] :
      ( ( mono_2Ec_2Ebool_2E_2F_5C @ V0 @ V1 )
    <=> ( V0
        & V1 ) ) ).

thf(reserved_2Elogic_2E_5C_2F,axiom,
    ! [V0: $o,V1: $o] :
      ( ( mono_2Ec_2Ebool_2E_5C_2F @ V0 @ V1 )
    <=> ( V0
        | V1 ) ) ).

thf(reserved_2Elogic_2E_7E,axiom,
    ! [V0: $o] :
      ( ( mono_2Ec_2Ebool_2E_7E @ V0 )
    <=> ( (~) @ V0 ) ) ).

thf(reserved_2Elogic_2E_3D_3D_3E,axiom,
    ! [V0: $o,V1: $o] :
      ( ( mono_2Ec_2Emin_2E_3D_3D_3E @ V0 @ V1 )
    <=> ( V0
       => V1 ) ) ).

thf(reserved_2Elogic_2E_3D,axiom,
    ! [A_27a: d,V0_2E0: u,V1_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Emin_2E_3D_2E2 @ ( s @ A_27a @ V0_2E0 ) @ ( s @ A_27a @ V1_2E0 ) ) ) )
    <=> ( ( s @ A_27a @ V0_2E0 )
        = ( s @ A_27a @ V1_2E0 ) ) ) ).

thf(reserved_2Equant_2E_21,axiom,
    ! [A_27a: d,V0f_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Ebool_2E_21_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ V0f_2E0 ) ) ) )
    <=> ! [V1x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ V0f_2E0 ) @ ( s @ A_27a @ V1x_2E0 ) ) ) ) ) ).

thf(reserved_2Equant_2E_3F,axiom,
    ! [A_27a: d,V0f_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Ebool_2E_3F_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ V0f_2E0 ) ) ) )
    <=> ? [V1x_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ V0f_2E0 ) @ ( s @ A_27a @ V1x_2E0 ) ) ) ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0_2E0: u] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ V0_2E0 ) ) ) )
      = ( s @ tyop_2Emin_2Ebool @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ V0_2E0 ) ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ V0_2E0 ) ) ).

thf(ij_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0_2E0: u] :
      ( ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( j_mono_2Etyop_2Enum_2Enum @ ( s @ tyop_2Enum_2Enum @ V0_2E0 ) ) ) )
      = ( s @ tyop_2Enum_2Enum @ V0_2E0 ) ) ).

thf(ji_2Emono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: $o] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: $o > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0: $o > $o > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29,axiom,
    ! [V0: $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( j_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ V0 ) ) )
      = V0 ) ).

thf(ji_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum] :
      ( ( j_mono_2Etyop_2Enum_2Enum @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V0 ) ) )
      = V0 ) ).

thf(arityeq1_2Ec_2Ebool_2E_21_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Ebool_2E_21_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ X0_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ tyop_2Emin_2Ebool ) @ c_2Ebool_2E_21_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ X0_2E0 ) ) ) ) ) ).

thf(arityeq2_2Ec_2Emin_2E_3D_2E2_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u] :
      ( ( ( s @ A_27a @ X0_2E0 )
        = ( s @ A_27a @ X1_2E0 ) )
    <=> ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ c_2Emin_2E_3D_2E0 ) @ ( s @ A_27a @ X0_2E0 ) ) ) @ ( s @ A_27a @ X1_2E0 ) ) ) ) ) ).

thf(arityeq1_2Ec_2Ebool_2E_3F_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Ebool_2E_3F_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ X0_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ tyop_2Emin_2Ebool ) @ c_2Ebool_2E_3F_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ X0_2E0 ) ) ) ) ) ).

thf(arityeq3_2Ec_2Ebool_2ECOND_2E3_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0: $o,X1_2E0: u,X2_2E0: u] :
      ( ( s @ A_27a @ ( c_2Ebool_2ECOND_2E3 @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ X0 ) ) @ ( s @ A_27a @ X1_2E0 ) @ ( s @ A_27a @ X2_2E0 ) ) )
      = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) ) ) @ c_2Ebool_2ECOND_2E0 ) @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ X0 ) ) ) ) @ ( s @ A_27a @ X1_2E0 ) ) ) @ ( s @ A_27a @ X2_2E0 ) ) ) ) ).

thf(arityeq3_2Ec_2Earithmetic_2EFUNPOW_2E3_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1: mono_2Etyop_2Enum_2Enum,X2_2E0: u] :
      ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ X0_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ X1 ) ) @ ( s @ A_27a @ X2_2E0 ) ) )
      = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) ) ) @ c_2Earithmetic_2EFUNPOW_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ X0_2E0 ) ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ X1 ) ) ) ) @ ( s @ A_27a @ X2_2E0 ) ) ) ) ).

thf(arityeq4_2Ec_2Earithmetic_2ENRC_2E4_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1: mono_2Etyop_2Enum_2Enum,X2_2E0: u,X3_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ X1 ) ) @ ( s @ A_27a @ X2_2E0 ) @ ( s @ A_27a @ X3_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) ) ) @ c_2Earithmetic_2ENRC_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ X1 ) ) ) ) @ ( s @ A_27a @ X2_2E0 ) ) ) @ ( s @ A_27a @ X3_2E0 ) ) ) ) ) ).

thf(arityeq3_2Ec_2Erelation_2ERTC_2E3_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2ERTC_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) @ ( s @ A_27a @ X1_2E0 ) @ ( s @ A_27a @ X2_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) ) @ c_2Erelation_2ERTC_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) ) ) @ ( s @ A_27a @ X1_2E0 ) ) ) @ ( s @ A_27a @ X2_2E0 ) ) ) ) ) ).

thf(arityeq3_2Ec_2Erelation_2ETC_2E3_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u,X1_2E0: u,X2_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2ETC_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) @ ( s @ A_27a @ X1_2E0 ) @ ( s @ A_27a @ X2_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) ) @ c_2Erelation_2ETC_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) ) ) @ ( s @ A_27a @ X1_2E0 ) ) ) @ ( s @ A_27a @ X2_2E0 ) ) ) ) ) ).

thf(arityeq1_2Ec_2Eprim__rec_2Emeasure_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] :
      ( ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( c_2Eprim__rec_2Emeasure_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Enum_2Enum ) @ X0_2E0 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Enum_2Enum ) @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) ) @ c_2Eprim__rec_2Emeasure_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Enum_2Enum ) @ X0_2E0 ) ) ) ) ).

thf(arityeq3_2Ec_2Earithmetic_2Enum__CASE_2E3_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0: mono_2Etyop_2Enum_2Enum,X1_2E0: u,X2_2E0: u] :
      ( ( s @ A_27a @ ( c_2Earithmetic_2Enum__CASE_2E3 @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ X0 ) ) @ ( s @ A_27a @ X1_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ X2_2E0 ) ) )
      = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ A_27a ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ A_27a ) ) ) @ c_2Earithmetic_2Enum__CASE_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ X0 ) ) ) ) @ ( s @ A_27a @ X1_2E0 ) ) ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ X2_2E0 ) ) ) ) ).

thf(arityeq1_2Ec_2Erelation_2Etransitive_2E1_2Emono_2EA_27a,axiom,
    ! [A_27a: d,X0_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2Etransitive_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ c_2Erelation_2Etransitive_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ X0_2E0 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: $o > $o,V1: $o] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( V0 @ V1 ) ) )
      = ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: $o > $o > $o,V1: $o] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29 @ ( V0 @ V1 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29_29 @ V0 ) ) @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0: $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum,V1: $o] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 @ ( V0 @ V1 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 @ V0 ) ) @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o,V1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( V0 @ V1 ) ) )
      = ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o,V1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ ( V0 @ V1 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29 @ V0 ) ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o,V1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( V0 @ V1 ) ) )
      = ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > $o,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( V0 @ V1 ) ) )
      = ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 @ V0 ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29 @ ( V0 @ V1 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ V0 ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ ( V0 @ V1 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29 @ V0 ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Eapp_2E2_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( V0 @ V1 ) ) )
      = ( s @ tyop_2Enum_2Enum @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ V0 ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1 ) ) ) ) ) ).

thf(monoeq_2Emono_2Ec_2Ebool_2ECOND_2E0_2Emono_2Etyop_2Enum_2Enum,axiom,
    ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29_29 @ mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum ) )
    = ( s @ ( tyop_2Emin_2Efun @ tyop_2Emin_2Ebool @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) ) ) @ c_2Ebool_2ECOND_2E0 ) ) ).

thf(monoeq_2Emono_2Ec_2Ebool_2ECOND_2E3_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: $o,V1: mono_2Etyop_2Enum_2Enum,V2: mono_2Etyop_2Enum_2Enum] :
      ( ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ V0 @ V1 @ V2 ) ) )
      = ( s @ tyop_2Enum_2Enum @ ( c_2Ebool_2ECOND_2E3 @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ V0 ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1 ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2 ) ) ) ) ) ).

thf(monoeq_2Emono_2Ec_2Ebool_2EONE__ONE_2E0_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ( ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_2Ctyop_2Emin_2Ebool_29 @ mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum ) )
    = ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ tyop_2Emin_2Ebool ) @ c_2Ebool_2EONE__ONE_2E0 ) ) ).

thf(monoeq_2Emono_2Ec_2Ebool_2EONE__ONE_2E1_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum @ V0 ) ) )
      = ( s @ tyop_2Emin_2Ebool @ ( c_2Ebool_2EONE__ONE_2E1 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Enum_2Enum ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29 @ V0 ) ) ) ) ) ).

thf(monoeq_2Emono_2Ec_2Erelation_2ERTC_2E0_2Emono_2Etyop_2Enum_2Enum,axiom,
    ( ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_29 @ mono_2Ec_2Erelation_2ERTC_2Emono_2Etyop_2Enum_2Enum ) )
    = ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) ) @ c_2Erelation_2ERTC_2E0 ) ) ).

thf(monoeq_2Emono_2Ec_2Erelation_2ERTC_2E1_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ ( mono_2Ec_2Erelation_2ERTC_2Emono_2Etyop_2Enum_2Enum @ V0 ) ) )
      = ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( c_2Erelation_2ERTC_2E1 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ V0 ) ) ) ) ) ).

thf(monoeq_2Emono_2Ec_2Erelation_2Etransitive_2E0_2Emono_2Etyop_2Enum_2Enum,axiom,
    ( ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_2Ctyop_2Emin_2Ebool_29 @ mono_2Ec_2Erelation_2Etransitive_2Emono_2Etyop_2Enum_2Enum ) )
    = ( s @ ( tyop_2Emin_2Efun @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ tyop_2Emin_2Ebool ) @ c_2Erelation_2Etransitive_2E0 ) ) ).

thf(monoeq_2Emono_2Ec_2Erelation_2Etransitive_2E1_2Emono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( mono_2Ec_2Erelation_2Etransitive_2Emono_2Etyop_2Enum_2Enum @ V0 ) ) )
      = ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2Etransitive_2E1 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ tyop_2Emin_2Ebool ) ) @ ( i_mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29 @ V0 ) ) ) ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: $o > $o,V1: $o] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Emin_2Ebool_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: $o > $o > $o,V1: $o] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Emin_2Ebool_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_29,axiom,
    ! [V0: $o > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum,V1: $o] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > $o,V1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29_29,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o ) > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o,V1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: ( mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum ) > $o,V1: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Ebool,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > $o,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Emin_2Ebool_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Emin_2Efun_28tyop_2Enum_2Enum_2Ctyop_2Enum_2Enum_29,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(monoapp_2Emono_2Eapp_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum,axiom,
    ! [V0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum,V1: mono_2Etyop_2Enum_2Enum] :
      ( ( V0 @ V1 )
      = ( V0 @ V1 ) ) ).

thf(thm_2Earithmetic_2EADD,axiom,
    ( ! [V0n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_2B @ mono_2Ec_2Enum_2E0 @ V0n )
        = V0n )
    & ! [V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Enum_2ESUC @ V1m ) @ V2n )
        = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2ENUMERAL__DEF,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0x )
      = V0x ) ).

thf(thm_2Earithmetic_2EALT__ZERO,axiom,
    mono_2Ec_2Earithmetic_2EZERO = mono_2Ec_2Enum_2E0 ).

thf(thm_2Earithmetic_2EBIT1,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EBIT1 @ V0n )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) ) ) ) ).

thf(thm_2Earithmetic_2EBIT2,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EBIT2 @ V0n )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2Enat__elim____magic,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2Enat__elim____magic @ V0n )
      = V0n ) ).

thf(thm_2Earithmetic_2ESUB,axiom,
    ( ! [V0m: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_2D @ mono_2Ec_2Enum_2E0 @ V0m )
        = mono_2Ec_2Enum_2E0 )
    & ! [V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Enum_2ESUC @ V1m ) @ V2n )
        = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Eprim__rec_2E_3C @ V1m @ V2n ) @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2D @ V1m @ V2n ) ) ) ) ) ).

thf(thm_2Earithmetic_2EMULT,axiom,
    ( ! [V0n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_2A @ mono_2Ec_2Enum_2E0 @ V0n )
        = mono_2Ec_2Enum_2E0 )
    & ! [V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V1m ) @ V2n )
        = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V2n ) @ V2n ) ) ) ).

thf(thm_2Earithmetic_2EEXP,axiom,
    ( ! [V0m: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2EEXP @ V0m @ mono_2Ec_2Enum_2E0 )
        = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
    & ! [V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2EEXP @ V1m @ ( mono_2Ec_2Enum_2ESUC @ V2n ) )
        = ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ ( mono_2Ec_2Earithmetic_2EEXP @ V1m @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2EGREATER__DEF,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E @ V0m @ V1n )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__OR__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        | ( V0m = V1n ) ) ) ).

thf(thm_2Earithmetic_2EGREATER__OR__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E_3D @ V0m @ V1n )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3E @ V0m @ V1n )
        | ( V0m = V1n ) ) ) ).

thf(thm_2Earithmetic_2EEVEN,axiom,
    ( ( ( mono_2Ec_2Earithmetic_2EEVEN @ mono_2Ec_2Enum_2E0 )
      = mono_2Ec_2Ebool_2ET )
    & ! [V0n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2EEVEN @ ( mono_2Ec_2Enum_2ESUC @ V0n ) )
      <=> ( (~) @ ( mono_2Ec_2Earithmetic_2EEVEN @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EODD,axiom,
    ( ( ( mono_2Ec_2Earithmetic_2EODD @ mono_2Ec_2Enum_2E0 )
      = mono_2Ec_2Ebool_2EF )
    & ! [V0n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2EODD @ ( mono_2Ec_2Enum_2ESUC @ V0n ) )
      <=> ( (~) @ ( mono_2Ec_2Earithmetic_2EODD @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2Enum__case__def,axiom,
    ! [A_27a: d] :
      ( ! [V0v_2E0: u,V1f_2E0: u] :
          ( ( s @ A_27a @ ( c_2Earithmetic_2Enum__CASE_2E3 @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ mono_2Ec_2Enum_2E0 ) ) @ ( s @ A_27a @ V0v_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_2E0 ) ) )
          = ( s @ A_27a @ V0v_2E0 ) )
      & ! [V2n: mono_2Etyop_2Enum_2Enum,V3v_2E0: u,V4f_2E0: u] :
          ( ( s @ A_27a @ ( c_2Earithmetic_2Enum__CASE_2E3 @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) @ ( s @ A_27a @ V3v_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V4f_2E0 ) ) )
          = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V4f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EFUNPOW,axiom,
    ! [A_27a: d] :
      ( ! [V0f_2E0: u,V1x_2E0: u] :
          ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V0f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ mono_2Ec_2Enum_2E0 ) ) @ ( s @ A_27a @ V1x_2E0 ) ) )
          = ( s @ A_27a @ V1x_2E0 ) )
      & ! [V2f_2E0: u,V3n: mono_2Etyop_2Enum_2Enum,V4x_2E0: u] :
          ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V2f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V3n ) ) ) @ ( s @ A_27a @ V4x_2E0 ) ) )
          = ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V2f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3n ) ) @ ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V2f_2E0 ) @ ( s @ A_27a @ V4x_2E0 ) ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC,axiom,
    ! [A_27a: d] :
      ( ! [V0R_2E0: u,V1x_2E0: u,V2y_2E0: u] :
          ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ mono_2Ec_2Enum_2E0 ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) )
        <=> ( ( s @ A_27a @ V1x_2E0 )
            = ( s @ A_27a @ V2y_2E0 ) ) )
      & ! [V3R_2E0: u,V4n: mono_2Etyop_2Enum_2Enum,V5x_2E0: u,V6y_2E0: u] :
          ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V3R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V4n ) ) ) @ ( s @ A_27a @ V5x_2E0 ) @ ( s @ A_27a @ V6y_2E0 ) ) ) )
        <=> ? [V7z_2E0: u] :
              ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V3R_2E0 ) @ ( s @ A_27a @ V5x_2E0 ) ) ) @ ( s @ A_27a @ V7z_2E0 ) ) ) )
              & ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V3R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V4n ) ) @ ( s @ A_27a @ V7z_2E0 ) @ ( s @ A_27a @ V6y_2E0 ) ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EFACT,axiom,
    ( ( ( mono_2Ec_2Earithmetic_2EFACT @ mono_2Ec_2Enum_2E0 )
      = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
    & ! [V0n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2EFACT @ ( mono_2Ec_2Enum_2ESUC @ V0n ) )
        = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V0n ) @ ( mono_2Ec_2Earithmetic_2EFACT @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EDIVISION,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1k: mono_2Etyop_2Enum_2Enum] :
          ( ( V1k
            = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2EDIV @ V1k @ V0n ) @ V0n ) @ ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n ) ) )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n ) @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EDIV2__def,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EDIV2 @ V0n )
      = ( mono_2Ec_2Earithmetic_2EDIV @ V0n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Earithmetic_2EMAX__DEF,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ V1n )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EMIN__DEF,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ V1n )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__def,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V1m )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ V1m ) @ ( mono_2Ec_2Earithmetic_2E_2D @ V1m @ V0n ) @ ( mono_2Ec_2Earithmetic_2E_2D @ V0n @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EONE,axiom,
    ( ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) )
    = ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2ETWO,axiom,
    ( ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) )
    = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Earithmetic_2ENORM__0,axiom,
    ( ( mono_2Ec_2Earithmetic_2ENUMERAL @ mono_2Ec_2Earithmetic_2EZERO )
    = mono_2Ec_2Enum_2E0 ) ).

thf(thm_2Earithmetic_2Enum__case__compute,axiom,
    ! [A_27a: d,F0: mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V2n: mono_2Etyop_2Enum_2Enum] :
          ( ( F0 @ V2n )
        <=> ( V2n = mono_2Ec_2Enum_2E0 ) )
     => ! [V0g_2E0: u,V1f_2E0: u,V2n: mono_2Etyop_2Enum_2Enum] :
          ( ( s @ A_27a @ ( c_2Earithmetic_2Enum__CASE_2E3 @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) @ ( s @ A_27a @ V1f_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V0g_2E0 ) ) )
          = ( s @ A_27a @ ( c_2Ebool_2ECOND_2E3 @ ( s @ tyop_2Emin_2Ebool @ ( i_mono_2Etyop_2Emin_2Ebool @ ( F0 @ V2n ) ) ) @ ( s @ A_27a @ V1f_2E0 ) @ ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V0g_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Eprim__rec_2EPRE @ V2n ) ) ) ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESUC__NOT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( mono_2Ec_2Enum_2E0
        = ( mono_2Ec_2Enum_2ESUC @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EADD__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ mono_2Ec_2Enum_2E0 )
      = V0m ) ).

thf(thm_2Earithmetic_2EADD__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EADD__CLAUSES,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ mono_2Ec_2Enum_2E0 @ V1m )
        = V1m )
      & ( ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ mono_2Ec_2Enum_2E0 )
        = V1m )
      & ( ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Enum_2ESUC @ V1m ) @ V0n )
        = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V0n ) ) )
      & ( ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ ( mono_2Ec_2Enum_2ESUC @ V0n ) )
        = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EADD__SYM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EADD__COMM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EADD__ASSOC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) @ V2p ) ) ).

thf(thm_2Earithmetic_2Enum__CASES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( V0m = mono_2Ec_2Enum_2E0 )
      | ? [V1n: mono_2Etyop_2Enum_2Enum] :
          ( V0m
          = ( mono_2Ec_2Enum_2ESUC @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ENOT__ZERO__LT__ZERO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( V0n = mono_2Ec_2Enum_2E0 ) )
    <=> ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n ) ) ).

thf(thm_2Earithmetic_2ENOT__LT__ZERO__EQ__ZERO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n ) )
    <=> ( V0n = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2ELESS__OR__EQ__ALT,axiom,
    ! [F0: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum] :
          ( ( F0 @ V0x @ V1y )
        <=> ( V1y
            = ( mono_2Ec_2Enum_2ESUC @ V0x ) ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D
        = ( mono_2Ec_2Erelation_2ERTC_2Emono_2Etyop_2Enum_2Enum @ F0 ) ) ) ).

thf(thm_2Earithmetic_2ELESS__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m )
     => ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V1n )
          = V0m ) ) ).

thf(thm_2Earithmetic_2Etransitive__LESS,axiom,
    mono_2Ec_2Erelation_2Etransitive_2Emono_2Etyop_2Enum_2Enum @ mono_2Ec_2Eprim__rec_2E_3C ).

thf(thm_2Earithmetic_2ELESS__TRANS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V2p ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V2p ) ) ).

thf(thm_2Earithmetic_2ELESS__ANTISYM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m ) ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__REV,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ ( mono_2Ec_2Enum_2ESUC @ V1n ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ ( mono_2Ec_2Enum_2ESUC @ V1n ) )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__MONO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0n ) @ ( mono_2Ec_2Enum_2ESUC @ V1m ) )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ V1m ) ) ).

thf(thm_2Earithmetic_2ELESS__LESS__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ ( mono_2Ec_2Enum_2ESUC @ V0m ) ) ) ) ).

thf(thm_2Earithmetic_2Etransitive__measure,axiom,
    ! [A_27a: d,V0f_2E0: u] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2Etransitive_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ ( c_2Eprim__rec_2Emeasure_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Enum_2Enum ) @ V0f_2E0 ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__OR,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n ) ) ).

thf(thm_2Earithmetic_2EOR__LESS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__IFF__LESS__SUC,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ V1m )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ ( mono_2Ec_2Enum_2ESUC @ V1m ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__IMP__LESS__SUC,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ V1m )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ ( mono_2Ec_2Enum_2ESUC @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EZERO__LESS__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ mono_2Ec_2Enum_2E0 @ V0n ) ).

thf(thm_2Earithmetic_2ELESS__SUC__EQ__COR,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( (~)
          @ ( ( mono_2Ec_2Enum_2ESUC @ V0m )
            = V1n ) ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__NOT__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( (~)
          @ ( V1n
            = ( mono_2Ec_2Enum_2ESUC @ V0m ) ) ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__0__CASES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Enum_2E0 = V0m )
      | ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__CASES__IMP,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( (~) @ ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) )
        & ( (~) @ ( V0m = V1n ) ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__CASES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
      | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EADD__INV__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
        = V0m )
     => ( V1n = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__ADD__EXISTS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m )
     => ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V1n )
          = V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__STRONG__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m )
     => ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Enum_2ESUC @ V2p ) @ V1n )
          = V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__SUC__REFL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ ( mono_2Ec_2Enum_2ESUC @ V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__ADD__NONZERO,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( V1n = mono_2Ec_2Enum_2E0 ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ENOT__SUC__LESS__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] : ( (~) @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0n ) @ mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2ENOT__LESS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) )
    <=> ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2ENOT__LESS__EQUAL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) )
    <=> ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__ANTISYM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ mono_2Ec_2Enum_2E0 )
    <=> ( V0n = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2ESUB__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2D @ mono_2Ec_2Enum_2E0 @ V0m )
        = mono_2Ec_2Enum_2E0 )
      & ( ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ mono_2Ec_2Enum_2E0 )
        = V0m ) ) ).

thf(thm_2Earithmetic_2ESUB__MONO__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Enum_2ESUC @ V0n ) @ ( mono_2Ec_2Enum_2ESUC @ V1m ) )
      = ( mono_2Ec_2Earithmetic_2E_2D @ V0n @ V1m ) ) ).

thf(thm_2Earithmetic_2ESUB__EQ__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n )
        = mono_2Ec_2Enum_2E0 )
    <=> ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2EADD1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Enum_2ESUC @ V0m )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Earithmetic_2ESUC__SUB1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
      = V0m ) ).

thf(thm_2Earithmetic_2EPRE__SUB1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2EPRE @ V0m )
      = ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Earithmetic_2EMULT__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ mono_2Ec_2Enum_2E0 )
      = mono_2Ec_2Enum_2E0 ) ).

thf(thm_2Earithmetic_2EMULT__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ ( mono_2Ec_2Enum_2ESUC @ V1n ) )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EMULT__LEFT__1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0m )
      = V0m ) ).

thf(thm_2Earithmetic_2EMULT__RIGHT__1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
      = V0m ) ).

thf(thm_2Earithmetic_2EMULT__CLAUSES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ mono_2Ec_2Enum_2E0 @ V0m )
        = mono_2Ec_2Enum_2E0 )
      & ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ mono_2Ec_2Enum_2E0 )
        = mono_2Ec_2Enum_2E0 )
      & ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0m )
        = V0m )
      & ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        = V0m )
      & ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n )
        = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ V1n ) )
      & ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ ( mono_2Ec_2Enum_2ESUC @ V1n ) )
        = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ) ).

thf(thm_2Earithmetic_2EMULT__SYM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EMULT__COMM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2ERIGHT__ADD__DISTRIB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) @ V2p )
      = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELEFT__ADD__DISTRIB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) )
      = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EMULT__ASSOC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ V2p ) ) ).

thf(thm_2Earithmetic_2ESUB__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m )
     => ( ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V1n )
        = V0m ) ) ).

thf(thm_2Earithmetic_2EPRE__SUB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2EPRE @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) )
      = ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Eprim__rec_2EPRE @ V0m ) @ V1n ) ) ).

thf(thm_2Earithmetic_2EADD__EQ__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
        = mono_2Ec_2Enum_2E0 )
    <=> ( ( V0m = mono_2Ec_2Enum_2E0 )
        & ( V1n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EADD__EQ__1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
        = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
    <=> ( ( ( V0m
            = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
          & ( V1n = mono_2Ec_2Enum_2E0 ) )
        | ( ( V0m = mono_2Ec_2Enum_2E0 )
          & ( V1n
            = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EADD__INV__0__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
        = V0m )
    <=> ( V1n = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EPRE__SUC__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
     => ( ( V0m
          = ( mono_2Ec_2Eprim__rec_2EPRE @ V1n ) )
      <=> ( ( mono_2Ec_2Enum_2ESUC @ V0m )
          = V1n ) ) ) ).

thf(thm_2Earithmetic_2EINV__PRE__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n ) )
     => ( ( ( mono_2Ec_2Eprim__rec_2EPRE @ V0m )
          = ( mono_2Ec_2Eprim__rec_2EPRE @ V1n ) )
      <=> ( V0m = V1n ) ) ) ).

thf(thm_2Earithmetic_2ELESS__SUC__NOT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
     => ( (~) @ ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ ( mono_2Ec_2Enum_2ESUC @ V0m ) ) ) ) ).

thf(thm_2Earithmetic_2EADD__EQ__SUB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p )
     => ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
          = V2p )
      <=> ( V0m
          = ( mono_2Ec_2Earithmetic_2E_2D @ V2p @ V1n ) ) ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__ADD__INV,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__ADD__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELT__ADD__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELT__ADD__LCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V1n ) )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2EEQ__MONO__ADD__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p )
        = ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
    <=> ( V0m = V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__MONO__ADD__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__TRANS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V2p ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__LESS__TRANS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V2p ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V2p ) ) ).

thf(thm_2Earithmetic_2ELESS__LESS__EQ__TRANS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V2p ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__LESS__EQ__MONO,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum,V3q: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V2p )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V3q ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V3q ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__REFL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V0m ) ).

thf(thm_2Earithmetic_2ELESS__IMP__LESS__OR__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__MULT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELESS__MONO__MULT2,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2i: mono_2Etyop_2Enum_2Enum,V3j: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V2i )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V3j ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V2i @ V3j ) ) ) ).

thf(thm_2Earithmetic_2ERIGHT__SUB__DISTRIB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
      = ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELEFT__SUB__DISTRIB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) )
      = ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ELESS__ADD__1,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m )
     => ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( V0m
          = ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EEXP__ADD,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1q: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEXP @ V2n @ ( mono_2Ec_2Earithmetic_2E_2B @ V0p @ V1q ) )
      = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2EEXP @ V2n @ V0p ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2n @ V1q ) ) ) ).

thf(thm_2Earithmetic_2ENOT__ODD__EQ__EVEN,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ V0n ) )
        = ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V1m ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQUAL__ANTISYM,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ V1m )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n ) )
     => ( V0n = V1m ) ) ).

thf(thm_2Earithmetic_2ELESS__ADD__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ELESS__OR__EQ__ADD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ V1m )
      | ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( V0n
          = ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EWOP,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ? [V1n: mono_2Etyop_2Enum_2Enum] : ( V0P @ V1n )
     => ? [V2n: mono_2Etyop_2Enum_2Enum] :
          ( ( V0P @ V2n )
          & ! [V3m: mono_2Etyop_2Enum_2Enum] :
              ( ( mono_2Ec_2Eprim__rec_2E_3C @ V3m @ V2n )
             => ( (~) @ ( V0P @ V3m ) ) ) ) ) ).

thf(thm_2Earithmetic_2ECOMPLETE__INDUCTION,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] :
          ( ! [V2m: mono_2Etyop_2Enum_2Enum] :
              ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2m @ V1n )
             => ( V0P @ V2m ) )
         => ( V0P @ V1n ) )
     => ! [V3n: mono_2Etyop_2Enum_2Enum] : ( V0P @ V3n ) ) ).

thf(thm_2Earithmetic_2EFORALL__NUM__THM,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] : ( V0P @ V1n )
    <=> ( ( V0P @ mono_2Ec_2Enum_2E0 )
        & ! [V2n: mono_2Etyop_2Enum_2Enum] :
            ( ( V0P @ V2n )
           => ( V0P @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESUC__SUB,axiom,
    ! [V0a: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Enum_2ESUC @ V0a ) @ V0a )
      = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Earithmetic_2ESUB__PLUS,axiom,
    ! [V0a: mono_2Etyop_2Enum_2Enum,V1b: mono_2Etyop_2Enum_2Enum,V2c: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ V0a @ ( mono_2Ec_2Earithmetic_2E_2B @ V1b @ V2c ) )
      = ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2D @ V0a @ V1b ) @ V2c ) ) ).

thf(thm_2Earithmetic_2EINV__PRE__LESS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
     => ! [V1n: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Eprim__rec_2EPRE @ V0m ) @ ( mono_2Ec_2Eprim__rec_2EPRE @ V1n ) )
          = ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EINV__PRE__LESS__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1m: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Eprim__rec_2EPRE @ V1m ) @ ( mono_2Ec_2Eprim__rec_2EPRE @ V0n ) )
          = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EPRE__LESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Eprim__rec_2EPRE @ V0m ) @ ( mono_2Ec_2Eprim__rec_2EPRE @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LESS__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2D @ V0n @ V1m ) @ V0n ) ).

thf(thm_2Earithmetic_2ESUB__EQ__EQ__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n )
        = V0m )
    <=> ( ( V0m = mono_2Ec_2Enum_2E0 )
        | ( V1n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LESS__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1m @ V0n )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2E_2D @ V0n @ V1m ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LESS__OR,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Earithmetic_2ELESS__SUB__ADD__LESS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2i: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2i @ ( mono_2Ec_2Earithmetic_2E_2D @ V0n @ V1m ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V2i @ V1m ) @ V0n ) ) ).

thf(thm_2Earithmetic_2ETIMES2,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n )
      = ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ V0n ) ) ).

thf(thm_2Earithmetic_2ELESS__MULT__MONO,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1i: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V2n ) @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V2n ) @ V1i ) )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1i ) ) ).

thf(thm_2Earithmetic_2EMULT__MONO__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1i: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V2n ) @ V0m )
        = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V2n ) @ V1i ) )
    <=> ( V0m = V1i ) ) ).

thf(thm_2Earithmetic_2EMULT__SUC__EQ,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V2n @ ( mono_2Ec_2Enum_2ESUC @ V0p ) )
        = ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ ( mono_2Ec_2Enum_2ESUC @ V0p ) ) )
    <=> ( V2n = V1m ) ) ).

thf(thm_2Earithmetic_2EMULT__EXP__MONO,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1q: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum,V3m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V2n @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ V1q ) @ V0p ) )
        = ( mono_2Ec_2Earithmetic_2E_2A @ V3m @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ V1q ) @ V0p ) ) )
    <=> ( V2n = V3m ) ) ).

thf(thm_2Earithmetic_2EEQ__ADD__LCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n )
        = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) )
    <=> ( V1n = V2p ) ) ).

thf(thm_2Earithmetic_2EEQ__ADD__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p )
        = ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
    <=> ( V0m = V1n ) ) ).

thf(thm_2Earithmetic_2EEQ__MULT__LCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n )
        = ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V2p ) )
    <=> ( ( V0m = mono_2Ec_2Enum_2E0 )
        | ( V1n = V2p ) ) ) ).

thf(thm_2Earithmetic_2EEQ__MULT__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V0m )
        = ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V0m ) )
    <=> ( ( V0m = mono_2Ec_2Enum_2E0 )
        | ( V1n = V2p ) ) ) ).

thf(thm_2Earithmetic_2EADD__SUB,axiom,
    ! [V0a: mono_2Etyop_2Enum_2Enum,V1c: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0a @ V1c ) @ V1c )
      = V0a ) ).

thf(thm_2Earithmetic_2ELESS__EQ__ADD__SUB,axiom,
    ! [V0c: mono_2Etyop_2Enum_2Enum,V1b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0c @ V1b )
     => ! [V2a: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2B @ V2a @ V1b ) @ V0c )
          = ( mono_2Ec_2Earithmetic_2E_2B @ V2a @ ( mono_2Ec_2Earithmetic_2E_2D @ V1b @ V0c ) ) ) ) ).

thf(thm_2Earithmetic_2ESUB__EQUAL__0,axiom,
    ! [V0c: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ V0c @ V0c )
      = mono_2Ec_2Enum_2E0 ) ).

thf(thm_2Earithmetic_2ELESS__EQ__SUB__LESS,axiom,
    ! [V0a: mono_2Etyop_2Enum_2Enum,V1b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1b @ V0a )
     => ! [V2c: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2D @ V0a @ V1b ) @ V2c )
          = ( mono_2Ec_2Eprim__rec_2E_3C @ V0a @ ( mono_2Ec_2Earithmetic_2E_2B @ V1b @ V2c ) ) ) ) ).

thf(thm_2Earithmetic_2ENOT__SUC__LESS__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0n ) @ V1m ) )
    <=> ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n ) ) ).

thf(thm_2Earithmetic_2ESUB__SUB,axiom,
    ! [V0b: mono_2Etyop_2Enum_2Enum,V1c: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1c @ V0b )
     => ! [V2a: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_2D @ V2a @ ( mono_2Ec_2Earithmetic_2E_2D @ V0b @ V1c ) )
          = ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2B @ V2a @ V1c ) @ V0b ) ) ) ).

thf(thm_2Earithmetic_2ELESS__IMP__LESS__ADD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ V1m )
     => ! [V2p: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LESS__EQ__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1p )
     => ! [V2n: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2D @ V1p @ V0m ) @ V2n )
          = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1p @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LESS__SUC,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2D @ V0p @ V1m ) @ ( mono_2Ec_2Enum_2ESUC @ V0p ) ) ).

thf(thm_2Earithmetic_2ESUB__CANCEL,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0p )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2m @ V0p ) )
     => ( ( ( mono_2Ec_2Earithmetic_2E_2D @ V0p @ V1n )
          = ( mono_2Ec_2Earithmetic_2E_2D @ V0p @ V2m ) )
      <=> ( V1n = V2m ) ) ) ).

thf(thm_2Earithmetic_2ECANCEL__SUB,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0p @ V1n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0p @ V2m ) )
     => ( ( ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V0p )
          = ( mono_2Ec_2Earithmetic_2E_2D @ V2m @ V0p ) )
      <=> ( V1n = V2m ) ) ) ).

thf(thm_2Earithmetic_2ENOT__EXP__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ V0m )
        = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EZERO__LESS__EXP,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ V0m ) ) ).

thf(thm_2Earithmetic_2EODD__OR__EVEN,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
    ? [V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( V0n
        = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) ) @ V1m ) )
      | ( V0n
        = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) ) @ V1m ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EXP__SUC__MONO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Enum_2ESUC @ V1m ) ) @ V0n ) @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Enum_2ESUC @ V1m ) ) @ ( mono_2Ec_2Enum_2ESUC @ V0n ) ) ) ).

thf(thm_2Earithmetic_2ELESS__LESS__CASES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( V0m = V1n )
      | ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V1n )
      | ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EGREATER__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E_3D @ V0n @ V1m )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__CASES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
      | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2ELESS__EQUAL__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
     => ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( V1n
          = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQ__EXISTS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
    <=> ? [V2p: mono_2Etyop_2Enum_2Enum] :
          ( V1n
          = ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) ) ) ).

thf(thm_2Earithmetic_2EMULT__EQ__0,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n )
        = mono_2Ec_2Enum_2E0 )
    <=> ( ( V0m = mono_2Ec_2Enum_2E0 )
        | ( V1n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EMULT__EQ__1,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V0x @ V1y )
        = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
    <=> ( ( V0x
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        & ( V1y
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Earithmetic_2EMULT__EQ__ID,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n )
        = V1n )
    <=> ( ( V0m
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        | ( V1n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2ELESS__MULT2,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EZERO__LESS__MULT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EZERO__LESS__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
        | ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EFACT__LESS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2EFACT @ V0n ) ) ).

thf(thm_2Earithmetic_2EEVEN__ODD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0n )
    <=> ( (~) @ ( mono_2Ec_2Earithmetic_2EODD @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EODD__EVEN,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EODD @ V0n )
    <=> ( (~) @ ( mono_2Ec_2Earithmetic_2EEVEN @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__OR__ODD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0n )
      | ( mono_2Ec_2Earithmetic_2EODD @ V0n ) ) ).

thf(thm_2Earithmetic_2EEVEN__AND__ODD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0n )
        & ( mono_2Ec_2Earithmetic_2EODD @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEVEN @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) )
    <=> ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0m )
        = ( mono_2Ec_2Earithmetic_2EEVEN @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__MULT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEVEN @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) )
    <=> ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0m )
        | ( mono_2Ec_2Earithmetic_2EEVEN @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EODD__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EODD @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) )
    <=> ( (~)
        @ ( ( mono_2Ec_2Earithmetic_2EODD @ V0m )
          = ( mono_2Ec_2Earithmetic_2EODD @ V1n ) ) ) ) ).

thf(thm_2Earithmetic_2EODD__MULT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EODD @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) )
    <=> ( ( mono_2Ec_2Earithmetic_2EODD @ V0m )
        & ( mono_2Ec_2Earithmetic_2EODD @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__DOUBLE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2EEVEN @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n ) ) ).

thf(thm_2Earithmetic_2EODD__DOUBLE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2EODD @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__ODD__EXISTS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0n )
       => ? [V1m: mono_2Etyop_2Enum_2Enum] :
            ( V0n
            = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V1m ) ) )
      & ( ( mono_2Ec_2Earithmetic_2EODD @ V0n )
       => ? [V2m: mono_2Etyop_2Enum_2Enum] :
            ( V0n
            = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V2m ) ) ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__EXISTS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEVEN @ V0n )
    <=> ? [V1m: mono_2Etyop_2Enum_2Enum] :
          ( V0n
          = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EODD__EXISTS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EODD @ V0n )
    <=> ? [V1m: mono_2Etyop_2Enum_2Enum] :
          ( V0n
          = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V1m ) ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__EXP__IFF,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEVEN @ ( mono_2Ec_2Earithmetic_2EEXP @ V1m @ V0n ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
        & ( mono_2Ec_2Earithmetic_2EEVEN @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EEVEN__EXP,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
        & ( mono_2Ec_2Earithmetic_2EEVEN @ V0m ) )
     => ( mono_2Ec_2Earithmetic_2EEVEN @ ( mono_2Ec_2Earithmetic_2EEXP @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EODD__EXP__IFF,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EODD @ ( mono_2Ec_2Earithmetic_2EEXP @ V1m @ V0n ) )
    <=> ( ( V0n = mono_2Ec_2Enum_2E0 )
        | ( mono_2Ec_2Earithmetic_2EODD @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EODD__EXP,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
        & ( mono_2Ec_2Earithmetic_2EODD @ V0m ) )
     => ( mono_2Ec_2Earithmetic_2EODD @ ( mono_2Ec_2Earithmetic_2EEXP @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EEQ__LESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( V0m = V1n )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m ) ) ) ).

thf(thm_2Earithmetic_2EADD__MONO__LESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) ) ).

thf(thm_2Earithmetic_2ELE__ADD__LCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) ) ).

thf(thm_2Earithmetic_2ELE__ADD__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V2p @ V0m ) )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) ) ).

thf(thm_2Earithmetic_2ENOT__LEQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) )
    <=> ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ V0m ) ) ).

thf(thm_2Earithmetic_2ENOT__NUM__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( V0m = V1n ) )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n )
        | ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ V0m ) ) ) ).

thf(thm_2Earithmetic_2ENOT__GREATER,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Earithmetic_2E_3E @ V0m @ V1n ) )
    <=> ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2ENOT__GREATER__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( (~) @ ( mono_2Ec_2Earithmetic_2E_3E_3D @ V0m @ V1n ) )
    <=> ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n ) ) ).

thf(thm_2Earithmetic_2ESUC__ONE__ADD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Enum_2ESUC @ V0n )
      = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n ) ) ).

thf(thm_2Earithmetic_2ESUC__ADD__SYM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) )
      = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ V0m ) ) ).

thf(thm_2Earithmetic_2ENOT__SUC__ADD__LESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] : ( (~) @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) ) @ V0m ) ) ).

thf(thm_2Earithmetic_2EMULT__LESS__EQ__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V2p ) @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V2p ) @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ELE__MULT__LCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V2p ) )
    <=> ( ( V0m = mono_2Ec_2Enum_2E0 )
        | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELE__MULT__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V1n ) )
    <=> ( ( V1n = mono_2Ec_2Enum_2E0 )
        | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELT__MULT__LCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V2p ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELT__MULT__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V2p @ V1n ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELT__MULT__CANCEL__LBARE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1m @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V0n ) )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1m )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n ) ) )
      & ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1m @ ( mono_2Ec_2Earithmetic_2E_2A @ V0n @ V1m ) )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1m )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2ELT__MULT__CANCEL__RBARE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V0n ) @ V1m )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1m )
          & ( V0n = mono_2Ec_2Enum_2E0 ) ) )
      & ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V0n ) @ V0n )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
          & ( V1m = mono_2Ec_2Enum_2E0 ) ) ) ) ).

thf(thm_2Earithmetic_2ELE__MULT__CANCEL__LBARE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V0n ) )
      <=> ( ( V1m = mono_2Ec_2Enum_2E0 )
          | ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n ) ) )
      & ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ ( mono_2Ec_2Earithmetic_2E_2A @ V0n @ V1m ) )
      <=> ( ( V1m = mono_2Ec_2Enum_2E0 )
          | ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2ELE__MULT__CANCEL__RBARE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V0n ) @ V1m )
      <=> ( ( V1m = mono_2Ec_2Enum_2E0 )
          | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V1m @ V0n ) @ V0n )
      <=> ( ( V0n = mono_2Ec_2Enum_2E0 )
          | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V1n ) @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__ADD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) @ V2p @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__SUB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__SUB,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
      = ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__SUC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n ) @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Enum_2ESUC @ V0m ) @ V1n ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__LESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ V1n )
        | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__LESS__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
      = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__LESS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ V1n ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__LESS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__GREATER__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E_3D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2E_3E_3D @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ V1n ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__GREATER__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E_3D @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3E_3D @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
        | ( mono_2Ec_2Earithmetic_2E_3E_3D @ mono_2Ec_2Enum_2E0 @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__GREATER,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E @ V0m @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3E @ ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p ) @ V1n )
        & ( mono_2Ec_2Earithmetic_2E_3E @ V0m @ mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__GREATER,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3E @ ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n ) @ V2p )
      = ( mono_2Ec_2Earithmetic_2E_3E @ V0m @ ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ESUB__LEFT__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( V0m
        = ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2p ) )
    <=> ( ( ( mono_2Ec_2Earithmetic_2E_2B @ V0m @ V2p )
          = V1n )
        | ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ mono_2Ec_2Enum_2E0 )
          & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) ) ) ) ).

thf(thm_2Earithmetic_2ESUB__RIGHT__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_2D @ V0m @ V1n )
        = V2p )
    <=> ( ( V0m
          = ( mono_2Ec_2Earithmetic_2E_2B @ V1n @ V2p ) )
        | ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
          & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ mono_2Ec_2Enum_2E0 ) ) ) ) ).

thf(thm_2Earithmetic_2ELE,axiom,
    ( ! [V0n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ mono_2Ec_2Enum_2E0 )
      <=> ( V0n = mono_2Ec_2Enum_2E0 ) )
    & ! [V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ ( mono_2Ec_2Enum_2ESUC @ V2n ) )
      <=> ( ( V1m
            = ( mono_2Ec_2Enum_2ESUC @ V2n ) )
          | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2EDA,axiom,
    ! [V0k: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
     => ? [V2r: mono_2Etyop_2Enum_2Enum,V3q: mono_2Etyop_2Enum_2Enum] :
          ( ( V0k
            = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V3q @ V1n ) @ V2r ) )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ V2r @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EMOD__ONE,axiom,
    ! [V0k: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMOD @ V0k @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) )
      = mono_2Ec_2Enum_2E0 ) ).

thf(thm_2Earithmetic_2EMOD__1,axiom,
    ! [V0k: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMOD @ V0k @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
      = mono_2Ec_2Enum_2E0 ) ).

thf(thm_2Earithmetic_2EDIV__LESS__EQ,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1k: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EDIV @ V1k @ V0n ) @ V1k ) ) ).

thf(thm_2Earithmetic_2EDIV__UNIQUE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1k: mono_2Etyop_2Enum_2Enum,V2q: mono_2Etyop_2Enum_2Enum] :
      ( ? [V3r: mono_2Etyop_2Enum_2Enum] :
          ( ( V1k
            = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V2q @ V0n ) @ V3r ) )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ V3r @ V0n ) )
     => ( ( mono_2Ec_2Earithmetic_2EDIV @ V1k @ V0n )
        = V2q ) ) ).

thf(thm_2Earithmetic_2EMOD__UNIQUE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1k: mono_2Etyop_2Enum_2Enum,V2r: mono_2Etyop_2Enum_2Enum] :
      ( ? [V3q: mono_2Etyop_2Enum_2Enum] :
          ( ( V1k
            = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V3q @ V0n ) @ V2r ) )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ V2r @ V0n ) )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n )
        = V2r ) ) ).

thf(thm_2Earithmetic_2EDIV__MULT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1r: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1r @ V0n )
     => ! [V2q: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V2q @ V0n ) @ V1r ) @ V0n )
          = V2q ) ) ).

thf(thm_2Earithmetic_2ELESS__MOD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1k: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1k @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n )
        = V1k ) ) ).

thf(thm_2Earithmetic_2EMOD__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1k: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2A @ V1k @ V0n ) @ V0n )
          = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EZERO__MOD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ mono_2Ec_2Enum_2E0 @ V0n )
        = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EZERO__DIV,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EDIV @ mono_2Ec_2Enum_2E0 @ V0n )
        = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EMOD__MULT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1r: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1r @ V0n )
     => ! [V2q: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V2q @ V0n ) @ V1r ) @ V0n )
          = V1r ) ) ).

thf(thm_2Earithmetic_2EMOD__TIMES,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1q: mono_2Etyop_2Enum_2Enum,V2r: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V1q @ V0n ) @ V2r ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ V2r @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EMOD__TIMES__SUB,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1q: mono_2Etyop_2Enum_2Enum,V2r: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1q )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2r @ V0n ) )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2E_2A @ V1q @ V0n ) @ V2r ) @ V0n )
        = ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2D @ V0n @ V2r ) @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EMOD__PLUS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1j: mono_2Etyop_2Enum_2Enum,V2k: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EMOD @ V1j @ V0n ) @ ( mono_2Ec_2Earithmetic_2EMOD @ V2k @ V0n ) ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V1j @ V2k ) @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EMOD__MOD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1k: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n ) ) ) ).

thf(thm_2Earithmetic_2ELESS__DIV__EQ__ZERO,axiom,
    ! [V0r: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0r @ V1n )
     => ( ( mono_2Ec_2Earithmetic_2EDIV @ V0r @ V1n )
        = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EMULT__DIV,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1q: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2E_2A @ V1q @ V0n ) @ V0n )
        = V1q ) ) ).

thf(thm_2Earithmetic_2EADD__DIV__ADD__DIV,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1x: mono_2Etyop_2Enum_2Enum,V2r: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V1x @ V0n ) @ V2r ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2E_2B @ V1x @ ( mono_2Ec_2Earithmetic_2EDIV @ V2r @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EADD__DIV__RWT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1m: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
          ( ( ( ( mono_2Ec_2Earithmetic_2EMOD @ V1m @ V0n )
              = mono_2Ec_2Enum_2E0 )
            | ( ( mono_2Ec_2Earithmetic_2EMOD @ V2p @ V0n )
              = mono_2Ec_2Enum_2E0 ) )
         => ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V2p ) @ V0n )
            = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EDIV @ V1m @ V0n ) @ ( mono_2Ec_2Earithmetic_2EDIV @ V2p @ V0n ) ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__MULT__MOD,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m ) )
     => ! [V2x: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2EMOD @ V2x @ ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V0m ) ) @ V1n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ V2x @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EDIV__ONE,axiom,
    ! [V0q: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EDIV @ V0q @ ( mono_2Ec_2Enum_2ESUC @ mono_2Ec_2Enum_2E0 ) )
      = V0q ) ).

thf(thm_2Earithmetic_2EDIV__1,axiom,
    ! [V0q: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EDIV @ V0q @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
      = V0q ) ).

thf(thm_2Earithmetic_2EDIVMOD__ID,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( ( mono_2Ec_2Earithmetic_2EDIV @ V0n @ V0n )
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        & ( ( mono_2Ec_2Earithmetic_2EMOD @ V0n @ V0n )
          = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EDIV__DIV__DIV__MULT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n ) )
     => ! [V2x: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2EDIV @ V2x @ V0m ) @ V1n )
          = ( mono_2Ec_2Earithmetic_2EDIV @ V2x @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ) ).

thf(thm_2Earithmetic_2ESUC__PRE,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0m )
    <=> ( ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Eprim__rec_2EPRE @ V0m ) )
        = V0m ) ) ).

thf(thm_2Earithmetic_2EDIV__LESS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1d: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V1d ) )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EDIV @ V0n @ V1d ) @ V0n ) ) ).

thf(thm_2Earithmetic_2EMOD__LESS,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EMOD @ V0m @ V1n ) @ V1n ) ) ).

thf(thm_2Earithmetic_2EADD__MODULUS,axiom,
    ( ! [V0n: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
       => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V1x @ V0n ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ V1x @ V0n ) ) )
    & ! [V2n: mono_2Etyop_2Enum_2Enum,V3x: mono_2Etyop_2Enum_2Enum] :
        ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2n )
       => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V2n @ V3x ) @ V2n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ V3x @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2EADD__MODULUS__LEFT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V1x @ V0n ) @ V0n )
        = ( mono_2Ec_2Earithmetic_2EMOD @ V1x @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EADD__MODULUS__RIGHT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ V1x ) @ V0n )
        = ( mono_2Ec_2Earithmetic_2EMOD @ V1x @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EDIV__P,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1p: mono_2Etyop_2Enum_2Enum,V2q: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2q )
     => ( ( V0P @ ( mono_2Ec_2Earithmetic_2EDIV @ V1p @ V2q ) )
      <=> ? [V3k: mono_2Etyop_2Enum_2Enum,V4r: mono_2Etyop_2Enum_2Enum] :
            ( ( V1p
              = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V3k @ V2q ) @ V4r ) )
            & ( mono_2Ec_2Eprim__rec_2E_3C @ V4r @ V2q )
            & ( V0P @ V3k ) ) ) ) ).

thf(thm_2Earithmetic_2EDIV__P__UNIV,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2n )
     => ( ( V0P @ ( mono_2Ec_2Earithmetic_2EDIV @ V1m @ V2n ) )
      <=> ! [V3q: mono_2Etyop_2Enum_2Enum,V4r: mono_2Etyop_2Enum_2Enum] :
            ( ( ( V1m
                = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V3q @ V2n ) @ V4r ) )
              & ( mono_2Ec_2Eprim__rec_2E_3C @ V4r @ V2n ) )
           => ( V0P @ V3q ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__P,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1p: mono_2Etyop_2Enum_2Enum,V2q: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2q )
     => ( ( V0P @ ( mono_2Ec_2Earithmetic_2EMOD @ V1p @ V2q ) )
      <=> ? [V3k: mono_2Etyop_2Enum_2Enum,V4r: mono_2Etyop_2Enum_2Enum] :
            ( ( V1p
              = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V3k @ V2q ) @ V4r ) )
            & ( mono_2Ec_2Eprim__rec_2E_3C @ V4r @ V2q )
            & ( V0P @ V4r ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__P__UNIV,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2n )
     => ( ( V0P @ ( mono_2Ec_2Earithmetic_2EMOD @ V1m @ V2n ) )
      <=> ! [V3q: mono_2Etyop_2Enum_2Enum,V4r: mono_2Etyop_2Enum_2Enum] :
            ( ( ( V1m
                = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2E_2A @ V3q @ V2n ) @ V4r ) )
              & ( mono_2Ec_2Eprim__rec_2E_3C @ V4r @ V2n ) )
           => ( V0P @ V4r ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__TIMES2,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ! [V1j: mono_2Etyop_2Enum_2Enum,V2k: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2EMOD @ V1j @ V0n ) @ ( mono_2Ec_2Earithmetic_2EMOD @ V2k @ V0n ) ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2A @ V1j @ V2k ) @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EMOD__COMMON__FACTOR,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1p: mono_2Etyop_2Enum_2Enum,V2q: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2q ) )
     => ( ( mono_2Ec_2Earithmetic_2E_2A @ V0n @ ( mono_2Ec_2Earithmetic_2EMOD @ V1p @ V2q ) )
        = ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2A @ V0n @ V1p ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V0n @ V2q ) ) ) ) ).

thf(thm_2Earithmetic_2EX__MOD__Y__EQ__X,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1y )
     => ( ( ( mono_2Ec_2Earithmetic_2EMOD @ V0x @ V1y )
          = V0x )
      <=> ( mono_2Ec_2Eprim__rec_2E_3C @ V0x @ V1y ) ) ) ).

thf(thm_2Earithmetic_2EDIV__LE__MONOTONE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum,V2y: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1x @ V2y ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EDIV @ V1x @ V0n ) @ ( mono_2Ec_2Earithmetic_2EDIV @ V2y @ V0n ) ) ) ).

thf(thm_2Earithmetic_2ELE__LT1,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0x @ V1y )
      = ( mono_2Ec_2Eprim__rec_2E_3C @ V0x @ ( mono_2Ec_2Earithmetic_2E_2B @ V1y @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Earithmetic_2EX__LE__DIV,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2z: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2z )
     => ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0x @ ( mono_2Ec_2Earithmetic_2EDIV @ V1y @ V2z ) )
        = ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0x @ V2z ) @ V1y ) ) ) ).

thf(thm_2Earithmetic_2EX__LT__DIV,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2z: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2z )
     => ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0x @ ( mono_2Ec_2Earithmetic_2EDIV @ V1y @ V2z ) )
        = ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2E_2B @ V0x @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) @ V2z ) @ V1y ) ) ) ).

thf(thm_2Earithmetic_2EDIV__LT__X,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2z: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2z )
     => ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EDIV @ V1y @ V2z ) @ V0x )
        = ( mono_2Ec_2Eprim__rec_2E_3C @ V1y @ ( mono_2Ec_2Earithmetic_2E_2A @ V0x @ V2z ) ) ) ) ).

thf(thm_2Earithmetic_2EDIV__LE__X,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2z: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2z )
     => ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EDIV @ V1y @ V2z ) @ V0x )
        = ( mono_2Ec_2Eprim__rec_2E_3C @ V1y @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2E_2B @ V0x @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) @ V2z ) ) ) ) ).

thf(thm_2Earithmetic_2EDIV__EQ__X,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2z: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2z )
     => ( ( ( mono_2Ec_2Earithmetic_2EDIV @ V1y @ V2z )
          = V0x )
      <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2A @ V0x @ V2z ) @ V1y )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ V1y @ ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ V0x ) @ V2z ) ) ) ) ) ).

thf(thm_2Earithmetic_2EDIV__MOD__MOD__DIV,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2k: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2k ) )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2EDIV @ V0m @ V1n ) @ V2k )
        = ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2EMOD @ V0m @ ( mono_2Ec_2Earithmetic_2E_2A @ V1n @ V2k ) ) @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EMULT__EQ__DIV,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2x )
     => ( ( ( mono_2Ec_2Earithmetic_2E_2A @ V2x @ V1y )
          = V0z )
      <=> ( ( V1y
            = ( mono_2Ec_2Earithmetic_2EDIV @ V0z @ V2x ) )
          & ( ( mono_2Ec_2Earithmetic_2EMOD @ V0z @ V2x )
            = mono_2Ec_2Enum_2E0 ) ) ) ) ).

thf(thm_2Earithmetic_2ENUMERAL__MULT__EQ__DIV,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2x: mono_2Etyop_2Enum_2Enum] :
      ( ( ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V2x ) ) @ V1y )
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0z ) )
      <=> ( ( V1y
            = ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0z ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V2x ) ) ) )
          & ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0z ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V2x ) ) )
            = mono_2Ec_2Enum_2E0 ) ) )
      & ( ( ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ V2x ) ) @ V1y )
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0z ) )
      <=> ( ( V1y
            = ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0z ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ V2x ) ) ) )
          & ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ V0z ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ V2x ) ) )
            = mono_2Ec_2Enum_2E0 ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__EQ__0__DIVISOR,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1k: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
     => ( ( ( mono_2Ec_2Earithmetic_2EMOD @ V1k @ V0n )
          = mono_2Ec_2Enum_2E0 )
      <=> ? [V2d: mono_2Etyop_2Enum_2Enum] :
            ( V1k
            = ( mono_2Ec_2Earithmetic_2E_2A @ V2d @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__SUC,axiom,
    ! [V0y: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0y )
        & ( (~)
          @ ( ( mono_2Ec_2Enum_2ESUC @ V1x )
            = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2EDIV @ V1x @ V0y ) ) @ V0y ) ) ) )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Enum_2ESUC @ V1x ) @ V0y )
        = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2EMOD @ V1x @ V0y ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__SUC__IFF,axiom,
    ! [V0y: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0y )
     => ( ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Enum_2ESUC @ V1x ) @ V0y )
          = ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2EMOD @ V1x @ V0y ) ) )
      <=> ( (~)
          @ ( ( mono_2Ec_2Enum_2ESUC @ V1x )
            = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2EDIV @ V1x @ V0y ) ) @ V0y ) ) ) ) ) ).

thf(thm_2Earithmetic_2EONE__MOD,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n )
        = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Earithmetic_2EONE__MOD__IFF,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n )
        & ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n )
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Earithmetic_2EMOD__LESS__EQ,axiom,
    ! [V0y: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0y )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EMOD @ V1x @ V0y ) @ V1x ) ) ).

thf(thm_2Earithmetic_2EMOD__LIFT__PLUS,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2k: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V2k @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ ( mono_2Ec_2Earithmetic_2EMOD @ V0x @ V1n ) ) ) )
     => ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V0x @ V2k ) @ V1n )
        = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EMOD @ V0x @ V1n ) @ V2k ) ) ) ).

thf(thm_2Earithmetic_2EMOD__LIFT__PLUS__IFF,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2k: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
     => ( ( ( mono_2Ec_2Earithmetic_2EMOD @ ( mono_2Ec_2Earithmetic_2E_2B @ V0x @ V2k ) @ V1n )
          = ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EMOD @ V0x @ V1n ) @ V2k ) )
      <=> ( mono_2Ec_2Eprim__rec_2E_3C @ V2k @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ ( mono_2Ec_2Earithmetic_2EMOD @ V0x @ V1n ) ) ) ) ) ).

thf(thm_2Earithmetic_2Enum__case__cong,axiom,
    ! [A_27a: d,V0v_27_2E0: u,V1f_27_2E0: u,V2M: mono_2Etyop_2Enum_2Enum,V3M_27: mono_2Etyop_2Enum_2Enum,V4v_2E0: u,V5f_2E0: u] :
      ( ( ( V2M = V3M_27 )
        & ( ( V3M_27 = mono_2Ec_2Enum_2E0 )
         => ( ( s @ A_27a @ V4v_2E0 )
            = ( s @ A_27a @ V0v_27_2E0 ) ) )
        & ! [V6n: mono_2Etyop_2Enum_2Enum] :
            ( ( V3M_27
              = ( mono_2Ec_2Enum_2ESUC @ V6n ) )
           => ( ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V5f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V6n ) ) ) )
              = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_27_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V6n ) ) ) ) ) ) )
     => ( ( s @ A_27a @ ( c_2Earithmetic_2Enum__CASE_2E3 @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2M ) ) @ ( s @ A_27a @ V4v_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V5f_2E0 ) ) )
        = ( s @ A_27a @ ( c_2Earithmetic_2Enum__CASE_2E3 @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3M_27 ) ) @ ( s @ A_27a @ V0v_27_2E0 ) @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_27_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESUC__ELIM__THM,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] : ( V0P @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ V1n )
    <=> ! [V2n: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2n )
         => ( V0P @ V2n @ ( mono_2Ec_2Earithmetic_2E_2D @ V2n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESUC__ELIM__NUMERALS,axiom,
    ! [A_27a: d,V0f_2E0: u,V1g_2E0: u] :
      ( ! [V2n: mono_2Etyop_2Enum_2Enum] :
          ( ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1g_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) ) )
          = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) ) @ V0f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) ) ) )
    <=> ( ! [V3n: mono_2Etyop_2Enum_2Enum] :
            ( ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1g_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V3n ) ) ) ) ) )
            = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) ) @ V0f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V3n ) ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V3n ) ) ) ) ) ) )
        & ! [V4n: mono_2Etyop_2Enum_2Enum] :
            ( ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1g_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ V4n ) ) ) ) ) )
            = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) ) @ V0f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V4n ) ) ) ) ) ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ V4n ) ) ) ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESUB__ELIM__THM,axiom,
    ! [V0b: mono_2Etyop_2Enum_2Enum,V1a: mono_2Etyop_2Enum_2Enum,V2P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ( V2P @ ( mono_2Ec_2Earithmetic_2E_2D @ V1a @ V0b ) )
    <=> ! [V3d: mono_2Etyop_2Enum_2Enum] :
          ( ( ( V0b
              = ( mono_2Ec_2Earithmetic_2E_2B @ V1a @ V3d ) )
           => ( V2P @ mono_2Ec_2Enum_2E0 ) )
          & ( ( V1a
              = ( mono_2Ec_2Earithmetic_2E_2B @ V0b @ V3d ) )
           => ( V2P @ V3d ) ) ) ) ).

thf(thm_2Earithmetic_2EPRE__ELIM__THM,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ( V1P @ ( mono_2Ec_2Eprim__rec_2EPRE @ V0n ) )
    <=> ! [V2m: mono_2Etyop_2Enum_2Enum] :
          ( ( ( V0n = mono_2Ec_2Enum_2E0 )
           => ( V1P @ mono_2Ec_2Enum_2E0 ) )
          & ( ( V0n
              = ( mono_2Ec_2Enum_2ESUC @ V2m ) )
           => ( V1P @ V2m ) ) ) ) ).

thf(thm_2Earithmetic_2EMULT__INCREASES,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0m )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Enum_2ESUC @ V1n ) @ ( mono_2Ec_2Earithmetic_2E_2A @ V0m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EEXP__ALWAYS__BIG__ENOUGH,axiom,
    ! [V0b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0b )
     => ! [V1n: mono_2Etyop_2Enum_2Enum] :
        ? [V2m: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V2m ) ) ) ).

thf(thm_2Earithmetic_2EEXP__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EEXP @ V0n @ V1m )
        = mono_2Ec_2Enum_2E0 )
    <=> ( ( V0n = mono_2Ec_2Enum_2E0 )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1m ) ) ) ).

thf(thm_2Earithmetic_2EZERO__LT__EXP,axiom,
    ! [V0y: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2EEXP @ V1x @ V0y ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1x )
        | ( V0y = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EEXP__1,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0n )
        = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
      & ( ( mono_2Ec_2Earithmetic_2EEXP @ V0n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        = V0n ) ) ).

thf(thm_2Earithmetic_2EEXP__EQ__1,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EEXP @ V0n @ V1m )
        = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
    <=> ( ( V0n
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        | ( V1m = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__LE__MONO,axiom,
    ! [V0b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0b )
     => ! [V1n: mono_2Etyop_2Enum_2Enum,V2m: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V2m ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V1n ) )
          = ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__LT__MONO,axiom,
    ! [V0b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0b )
     => ! [V1n: mono_2Etyop_2Enum_2Enum,V2m: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V2m ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V1n ) )
          = ( mono_2Ec_2Eprim__rec_2E_3C @ V2m @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__INJECTIVE,axiom,
    ! [V0b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V0b )
     => ! [V1n: mono_2Etyop_2Enum_2Enum,V2m: mono_2Etyop_2Enum_2Enum] :
          ( ( ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V1n )
            = ( mono_2Ec_2Earithmetic_2EEXP @ V0b @ V2m ) )
        <=> ( V1n = V2m ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__LEQ__MONO__IMP,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2b: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2b )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n ) )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EEXP @ V2b @ V1m ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2b @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__LEQ__MONO__SUC__IMP,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ V2b ) @ V1m ) @ ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Enum_2ESUC @ V2b ) @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__LE__IFF,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EEXP @ V2b @ V1m ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2b @ V0n ) )
    <=> ( ( ( V2b = mono_2Ec_2Enum_2E0 )
          & ( V0n = mono_2Ec_2Enum_2E0 ) )
        | ( ( V2b = mono_2Ec_2Enum_2E0 )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1m ) )
        | ( V2b
          = ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
        | ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V2b )
          & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EX__LE__X__EXP,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
     => ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0x @ ( mono_2Ec_2Earithmetic_2EEXP @ V0x @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EX__LT__EXP__X,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V1b )
     => ( mono_2Ec_2Eprim__rec_2E_3C @ V0x @ ( mono_2Ec_2Earithmetic_2EEXP @ V1b @ V0x ) ) ) ).

thf(thm_2Earithmetic_2EZERO__EXP,axiom,
    ! [F0: mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V0x: mono_2Etyop_2Enum_2Enum] :
          ( ( F0 @ V0x )
        <=> ( V0x = mono_2Ec_2Enum_2E0 ) )
     => ! [V0x: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2EEXP @ mono_2Ec_2Enum_2E0 @ V0x )
          = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( F0 @ V0x ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EX__LT__EXP__X__IFF,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0x @ ( mono_2Ec_2Earithmetic_2EEXP @ V1b @ V0x ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) @ V1b )
        | ( V0x = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EEXP__EXP__LT__MONO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1a: mono_2Etyop_2Enum_2Enum,V2b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EEXP @ V1a @ V0n ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2b @ V0n ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1a @ V2b )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V0n ) ) ) ).

thf(thm_2Earithmetic_2EEXP__EXP__LE__MONO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1a: mono_2Etyop_2Enum_2Enum,V2b: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EEXP @ V1a @ V0n ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2b @ V0n ) )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1a @ V2b )
        | ( V0n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EEXP__EXP__INJECTIVE,axiom,
    ! [V0b1: mono_2Etyop_2Enum_2Enum,V1b2: mono_2Etyop_2Enum_2Enum,V2x: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EEXP @ V0b1 @ V2x )
        = ( mono_2Ec_2Earithmetic_2EEXP @ V1b2 @ V2x ) )
    <=> ( ( V2x = mono_2Ec_2Enum_2E0 )
        | ( V0b1 = V1b2 ) ) ) ).

thf(thm_2Earithmetic_2EEXP__SUB,axiom,
    ! [V0p: mono_2Etyop_2Enum_2Enum,V1q: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V2n )
        & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1q @ V0p ) )
     => ( ( mono_2Ec_2Earithmetic_2EEXP @ V2n @ ( mono_2Ec_2Earithmetic_2E_2D @ V0p @ V1q ) )
        = ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2EEXP @ V2n @ V0p ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2n @ V1q ) ) ) ) ).

thf(thm_2Earithmetic_2EEXP__SUB__NUMERAL,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1n )
     => ( ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2EEXP @ V1n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V0x ) ) ) @ V1n )
          = ( mono_2Ec_2Earithmetic_2EEXP @ V1n @ ( mono_2Ec_2Earithmetic_2E_2D @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V0x ) ) @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) )
        & ( ( mono_2Ec_2Earithmetic_2EDIV @ ( mono_2Ec_2Earithmetic_2EEXP @ V1n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ V0x ) ) ) @ V1n )
          = ( mono_2Ec_2Earithmetic_2EEXP @ V1n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ V0x ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EEXP__BASE__MULT,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum,V2y: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Earithmetic_2E_2A @ V1x @ V2y ) @ V0z )
      = ( mono_2Ec_2Earithmetic_2E_2A @ ( mono_2Ec_2Earithmetic_2EEXP @ V1x @ V0z ) @ ( mono_2Ec_2Earithmetic_2EEXP @ V2y @ V0z ) ) ) ).

thf(thm_2Earithmetic_2EEXP__EXP__MULT,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum,V2y: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EEXP @ V1x @ ( mono_2Ec_2Earithmetic_2E_2A @ V2y @ V0z ) )
      = ( mono_2Ec_2Earithmetic_2EEXP @ ( mono_2Ec_2Earithmetic_2EEXP @ V1x @ V2y ) @ V0z ) ) ).

thf(thm_2Earithmetic_2EMAX__COMM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2EMAX @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EMIN__COMM,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ V1n )
      = ( mono_2Ec_2Earithmetic_2EMIN @ V1n @ V0m ) ) ).

thf(thm_2Earithmetic_2EMAX__ASSOC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ ( mono_2Ec_2Earithmetic_2EMAX @ V1n @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2EMAX @ ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ V1n ) @ V2p ) ) ).

thf(thm_2Earithmetic_2EMIN__ASSOC,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ ( mono_2Ec_2Earithmetic_2EMIN @ V1n @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2EMIN @ ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ V1n ) @ V2p ) ) ).

thf(thm_2Earithmetic_2EMIN__MAX__EQ,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ V1n )
        = ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ V1n ) )
    <=> ( V0m = V1n ) ) ).

thf(thm_2Earithmetic_2EMIN__MAX__LT,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ V1n ) )
    <=> ( (~) @ ( V0m = V1n ) ) ) ).

thf(thm_2Earithmetic_2EMIN__MAX__LE,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EMIN @ V0m @ V1n ) @ ( mono_2Ec_2Earithmetic_2EMAX @ V0m @ V1n ) ) ).

thf(thm_2Earithmetic_2EMIN__MAX__PRED,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( V0P @ V1m )
        & ( V0P @ V2n ) )
     => ( ( V0P @ ( mono_2Ec_2Earithmetic_2EMIN @ V1m @ V2n ) )
        & ( V0P @ ( mono_2Ec_2Earithmetic_2EMAX @ V1m @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2EMIN__LT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EMIN @ V1m @ V0n ) @ V2p )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1m @ V2p )
          | ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ V2p ) ) )
      & ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2p @ ( mono_2Ec_2Earithmetic_2EMIN @ V1m @ V0n ) )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2p @ V1m )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ V2p @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EMAX__LT,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2p @ ( mono_2Ec_2Earithmetic_2EMAX @ V1m @ V0n ) )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2p @ V1m )
          | ( mono_2Ec_2Eprim__rec_2E_3C @ V2p @ V0n ) ) )
      & ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2EMAX @ V1m @ V0n ) @ V2p )
      <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1m @ V2p )
          & ( mono_2Ec_2Eprim__rec_2E_3C @ V0n @ V2p ) ) ) ) ).

thf(thm_2Earithmetic_2EMIN__LE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EMIN @ V1m @ V0n ) @ V2p )
      <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V2p )
          | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ V2p ) ) )
      & ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ ( mono_2Ec_2Earithmetic_2EMIN @ V1m @ V0n ) )
      <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ V1m )
          & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ V0n ) ) ) ) ).

thf(thm_2Earithmetic_2EMAX__LE,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ ( mono_2Ec_2Earithmetic_2EMAX @ V1m @ V0n ) )
      <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ V1m )
          | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2p @ V0n ) ) )
      & ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EMAX @ V1m @ V0n ) @ V2p )
      <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1m @ V2p )
          & ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0n @ V2p ) ) ) ) ).

thf(thm_2Earithmetic_2EMIN__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EMIN @ V0n @ mono_2Ec_2Enum_2E0 )
        = mono_2Ec_2Enum_2E0 )
      & ( ( mono_2Ec_2Earithmetic_2EMIN @ mono_2Ec_2Enum_2E0 @ V0n )
        = mono_2Ec_2Enum_2E0 ) ) ).

thf(thm_2Earithmetic_2EMAX__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EMAX @ V0n @ mono_2Ec_2Enum_2E0 )
        = V0n )
      & ( ( mono_2Ec_2Earithmetic_2EMAX @ mono_2Ec_2Enum_2E0 @ V0n )
        = V0n ) ) ).

thf(thm_2Earithmetic_2EMAX__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EMAX @ V1m @ V0n )
        = mono_2Ec_2Enum_2E0 )
    <=> ( ( V1m = mono_2Ec_2Enum_2E0 )
        & ( V0n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EMIN__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EMIN @ V1m @ V0n )
        = mono_2Ec_2Enum_2E0 )
    <=> ( ( V1m = mono_2Ec_2Enum_2E0 )
        | ( V0n = mono_2Ec_2Enum_2E0 ) ) ) ).

thf(thm_2Earithmetic_2EMIN__IDEM,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMIN @ V0n @ V0n )
      = V0n ) ).

thf(thm_2Earithmetic_2EMAX__IDEM,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMAX @ V0n @ V0n )
      = V0n ) ).

thf(thm_2Earithmetic_2EEXISTS__GREATEST,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ( ? [V1x: mono_2Etyop_2Enum_2Enum] : ( V0P @ V1x )
        & ? [V2x: mono_2Etyop_2Enum_2Enum] :
          ! [V3y: mono_2Etyop_2Enum_2Enum] :
            ( ( mono_2Ec_2Earithmetic_2E_3E @ V3y @ V2x )
           => ( (~) @ ( V0P @ V3y ) ) ) )
    <=> ? [V4x: mono_2Etyop_2Enum_2Enum] :
          ( ( V0P @ V4x )
          & ! [V5y: mono_2Etyop_2Enum_2Enum] :
              ( ( mono_2Ec_2Earithmetic_2E_3E @ V5y @ V4x )
             => ( (~) @ ( V0P @ V5y ) ) ) ) ) ).

thf(thm_2Earithmetic_2EEXISTS__NUM,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ? [V1n: mono_2Etyop_2Enum_2Enum] : ( V0P @ V1n )
    <=> ( ( V0P @ mono_2Ec_2Enum_2E0 )
        | ? [V2m: mono_2Etyop_2Enum_2Enum] : ( V0P @ ( mono_2Ec_2Enum_2ESUC @ V2m ) ) ) ) ).

thf(thm_2Earithmetic_2EFORALL__NUM,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] : ( V0P @ V1n )
    <=> ( ( V0P @ mono_2Ec_2Enum_2E0 )
        & ! [V2n: mono_2Etyop_2Enum_2Enum] : ( V0P @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) ) ).

thf(thm_2Earithmetic_2EBOUNDED__FORALL__THM,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1c: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1c )
     => ( ! [V2n: mono_2Etyop_2Enum_2Enum] :
            ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2n @ V1c )
           => ( V0P @ V2n ) )
      <=> ( ( V0P @ ( mono_2Ec_2Earithmetic_2E_2D @ V1c @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) )
          & ! [V3n: mono_2Etyop_2Enum_2Enum] :
              ( ( mono_2Ec_2Eprim__rec_2E_3C @ V3n @ ( mono_2Ec_2Earithmetic_2E_2D @ V1c @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) )
             => ( V0P @ V3n ) ) ) ) ) ).

thf(thm_2Earithmetic_2EBOUNDED__EXISTS__THM,axiom,
    ! [V0P: mono_2Etyop_2Enum_2Enum > $o,V1c: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ mono_2Ec_2Enum_2E0 @ V1c )
     => ( ? [V2n: mono_2Etyop_2Enum_2Enum] :
            ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2n @ V1c )
            & ( V0P @ V2n ) )
      <=> ( ( V0P @ ( mono_2Ec_2Earithmetic_2E_2D @ V1c @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) )
          | ? [V3n: mono_2Etyop_2Enum_2Enum] :
              ( ( mono_2Ec_2Eprim__rec_2E_3C @ V3n @ ( mono_2Ec_2Earithmetic_2E_2D @ V1c @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) )
              & ( V0P @ V3n ) ) ) ) ) ).

thf(thm_2Earithmetic_2Etransitive__monotone,axiom,
    ! [A_27a: d,V0R_2E0: u,V1f_2E0: u] :
      ( ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2Etransitive_2E1 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) ) ) )
        & ! [V2n: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) ) ) ) ) @ ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) ) ) ) ) ) )
     => ! [V3m: mono_2Etyop_2Enum_2Enum,V4n: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Eprim__rec_2E_3C @ V3m @ V4n )
         => ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3m ) ) ) ) ) ) @ ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ tyop_2Enum_2Enum @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V4n ) ) ) ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ESTRICTLY__INCREASING__TC,axiom,
    ! [V0f: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ ( V0f @ V1n ) @ ( V0f @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) )
     => ! [V2m: mono_2Etyop_2Enum_2Enum,V3n: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Eprim__rec_2E_3C @ V2m @ V3n )
         => ( mono_2Ec_2Eprim__rec_2E_3C @ ( V0f @ V2m ) @ ( V0f @ V3n ) ) ) ) ).

thf(thm_2Earithmetic_2ESTRICTLY__INCREASING__ONE__ONE,axiom,
    ! [V0f: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ ( V0f @ V1n ) @ ( V0f @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) )
     => ( mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum @ V0f ) ) ).

thf(thm_2Earithmetic_2EONE__ONE__INV__IMAGE__BOUNDED,axiom,
    ! [V0f: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum @ V0f )
     => ! [V1b: mono_2Etyop_2Enum_2Enum] :
        ? [V2a: mono_2Etyop_2Enum_2Enum] :
        ! [V3x: mono_2Etyop_2Enum_2Enum] :
          ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( V0f @ V3x ) @ V1b )
         => ( mono_2Ec_2Earithmetic_2E_3C_3D @ V3x @ V2a ) ) ) ).

thf(thm_2Earithmetic_2EONE__ONE__UNBOUNDED,axiom,
    ! [V0f: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Ebool_2EONE__ONE_2Emono_2Etyop_2Enum_2Enum_20mono_2Etyop_2Enum_2Enum @ V0f )
     => ! [V1b: mono_2Etyop_2Enum_2Enum] :
        ? [V2n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ V1b @ ( V0f @ V2n ) ) ) ).

thf(thm_2Earithmetic_2ESTRICTLY__INCREASING__UNBOUNDED,axiom,
    ! [V0f: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( ! [V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ ( V0f @ V1n ) @ ( V0f @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) )
     => ! [V2b: mono_2Etyop_2Enum_2Enum] :
        ? [V3n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ V2b @ ( V0f @ V3n ) ) ) ).

thf(thm_2Earithmetic_2ENOT__STRICTLY__DECREASING,axiom,
    ! [V0f: mono_2Etyop_2Enum_2Enum > mono_2Etyop_2Enum_2Enum] :
      ( (~)
      @ ! [V1n: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Eprim__rec_2E_3C @ ( V0f @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) @ ( V0f @ V1n ) ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__SYM,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V1m )
      = ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V1m @ V0n ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__COMM,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V1m )
      = ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V1m @ V0n ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__EQS,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V0n )
      = mono_2Ec_2Enum_2E0 ) ).

thf(thm_2Earithmetic_2EABS__DIFF__EQ__0,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V1m )
        = mono_2Ec_2Enum_2E0 )
    <=> ( V0n = V1m ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__ZERO,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ mono_2Ec_2Enum_2E0 )
        = V0n )
      & ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ mono_2Ec_2Enum_2E0 @ V0n )
        = V0n ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__SUC,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ ( mono_2Ec_2Enum_2ESUC @ V0n ) @ ( mono_2Ec_2Enum_2ESUC @ V1m ) )
      = ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V1m ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__SUC__LE,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1z: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ ( mono_2Ec_2Enum_2ESUC @ V1z ) ) @ ( mono_2Ec_2Enum_2ESUC @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ V1z ) ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__PLUS__LE,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1z: mono_2Etyop_2Enum_2Enum,V2y: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ ( mono_2Ec_2Earithmetic_2E_2B @ V2y @ V1z ) ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V2y @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ V1z ) ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__LE__SUM,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1x: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V1x @ V0z ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1x @ V0z ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__TRIANGLE__lem,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0x @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ V1y ) @ V1y ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__TRIANGLE,axiom,
    ! [V0x: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2z: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ V2z ) @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0x @ V1y ) @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V1y @ V2z ) ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__ADD__SAME,axiom,
    ! [V0n: mono_2Etyop_2Enum_2Enum,V1m: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EABS__DIFF @ ( mono_2Ec_2Earithmetic_2E_2B @ V0n @ V2p ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V2p ) )
      = ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n @ V1m ) ) ).

thf(thm_2Earithmetic_2ELE__SUB__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2D @ V2p @ V0m ) )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V0m )
        | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V1n @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELT__SUB__RCANCEL,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum,V2p: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V0m ) @ ( mono_2Ec_2Earithmetic_2E_2D @ V2p @ V0m ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V1n @ V2p )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V0m @ V2p ) ) ) ).

thf(thm_2Earithmetic_2ELE__SUB__LCANCEL,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2E_2D @ V2x @ V1y ) @ ( mono_2Ec_2Earithmetic_2E_2D @ V2x @ V0z ) )
    <=> ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0z @ V1y )
        | ( mono_2Ec_2Earithmetic_2E_3C_3D @ V2x @ V1y ) ) ) ).

thf(thm_2Earithmetic_2ELT__SUB__LCANCEL,axiom,
    ! [V0z: mono_2Etyop_2Enum_2Enum,V1y: mono_2Etyop_2Enum_2Enum,V2x: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Eprim__rec_2E_3C @ ( mono_2Ec_2Earithmetic_2E_2D @ V2x @ V1y ) @ ( mono_2Ec_2Earithmetic_2E_2D @ V2x @ V0z ) )
    <=> ( ( mono_2Ec_2Eprim__rec_2E_3C @ V0z @ V1y )
        & ( mono_2Ec_2Eprim__rec_2E_3C @ V0z @ V2x ) ) ) ).

thf(thm_2Earithmetic_2EABS__DIFF__SUMS,axiom,
    ! [V0n1: mono_2Etyop_2Enum_2Enum,V1n2: mono_2Etyop_2Enum_2Enum,V2m1: mono_2Etyop_2Enum_2Enum,V3m2: mono_2Etyop_2Enum_2Enum] : ( mono_2Ec_2Earithmetic_2E_3C_3D @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ ( mono_2Ec_2Earithmetic_2E_2B @ V0n1 @ V1n2 ) @ ( mono_2Ec_2Earithmetic_2E_2B @ V2m1 @ V3m2 ) ) @ ( mono_2Ec_2Earithmetic_2E_2B @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V0n1 @ V2m1 ) @ ( mono_2Ec_2Earithmetic_2EABS__DIFF @ V1n2 @ V3m2 ) ) ) ).

thf(thm_2Earithmetic_2EFUNPOW__SUC,axiom,
    ! [A_27a: d,V0f_2E0: u,V1n: mono_2Etyop_2Enum_2Enum,V2x_2E0: u] :
      ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V0f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V1n ) ) ) @ ( s @ A_27a @ V2x_2E0 ) ) )
      = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V0f_2E0 ) @ ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V0f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1n ) ) @ ( s @ A_27a @ V2x_2E0 ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EFUNPOW__0,axiom,
    ! [A_27a: d,V0x_2E0: u,V1f_2E0: u] :
      ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ mono_2Ec_2Enum_2E0 ) ) @ ( s @ A_27a @ V0x_2E0 ) ) )
      = ( s @ A_27a @ V0x_2E0 ) ) ).

thf(thm_2Earithmetic_2EFUNPOW__ADD,axiom,
    ! [A_27a: d,V0x_2E0: u,V1f_2E0: u,V2m: mono_2Etyop_2Enum_2Enum,V3n: mono_2Etyop_2Enum_2Enum] :
      ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_2B @ V2m @ V3n ) ) ) @ ( s @ A_27a @ V0x_2E0 ) ) )
      = ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2m ) ) @ ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3n ) ) @ ( s @ A_27a @ V0x_2E0 ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2EFUNPOW__1,axiom,
    ! [A_27a: d,V0x_2E0: u,V1f_2E0: u] :
      ( ( s @ A_27a @ ( c_2Earithmetic_2EFUNPOW_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V1f_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) @ ( s @ A_27a @ V0x_2E0 ) ) )
      = ( s @ A_27a @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ A_27a ) @ V1f_2E0 ) @ ( s @ A_27a @ V0x_2E0 ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC__0,axiom,
    ! [A_27a: d,V0R_2E0: u,V1x_2E0: u,V2y_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ mono_2Ec_2Enum_2E0 ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) )
    <=> ( ( s @ A_27a @ V1x_2E0 )
        = ( s @ A_27a @ V2y_2E0 ) ) ) ).

thf(thm_2Earithmetic_2ENRC__1,axiom,
    ! [A_27a: d,V0y_2E0: u,V1x_2E0: u,V2R_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V2R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V0y_2E0 ) ) ) )
      = ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V2R_2E0 ) @ ( s @ A_27a @ V1x_2E0 ) ) ) @ ( s @ A_27a @ V0y_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC__ADD__I,axiom,
    ! [A_27a: d,V0R_2E0: u,V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum,V3x_2E0: u,V4y_2E0: u,V5z_2E0: u] :
      ( ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1m ) ) @ ( s @ A_27a @ V3x_2E0 ) @ ( s @ A_27a @ V4y_2E0 ) ) ) )
        & ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) @ ( s @ A_27a @ V4y_2E0 ) @ ( s @ A_27a @ V5z_2E0 ) ) ) ) )
     => ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V2n ) ) ) @ ( s @ A_27a @ V3x_2E0 ) @ ( s @ A_27a @ V5z_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC__ADD__E,axiom,
    ! [A_27a: d,V0R_2E0: u,V1m: mono_2Etyop_2Enum_2Enum,V2n: mono_2Etyop_2Enum_2Enum,V3x_2E0: u,V4z_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_2B @ V1m @ V2n ) ) ) @ ( s @ A_27a @ V3x_2E0 ) @ ( s @ A_27a @ V4z_2E0 ) ) ) )
     => ? [V5y_2E0: u] :
          ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1m ) ) @ ( s @ A_27a @ V3x_2E0 ) @ ( s @ A_27a @ V5y_2E0 ) ) ) )
          & ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) @ ( s @ A_27a @ V5y_2E0 ) @ ( s @ A_27a @ V4z_2E0 ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC__ADD__EQN,axiom,
    ! [A_27a: d,V0z_2E0: u,V1x_2E0: u,V2n: mono_2Etyop_2Enum_2Enum,V3m: mono_2Etyop_2Enum_2Enum,V4R_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V4R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2E_2B @ V3m @ V2n ) ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V0z_2E0 ) ) ) )
    <=> ? [V5y_2E0: u] :
          ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V4R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3m ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V5y_2E0 ) ) ) )
          & ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V4R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) @ ( s @ A_27a @ V5y_2E0 ) @ ( s @ A_27a @ V0z_2E0 ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC__SUC__RECURSE__LEFT,axiom,
    ! [A_27a: d,V0y_2E0: u,V1x_2E0: u,V2n: mono_2Etyop_2Enum_2Enum,V3R_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V3R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V2n ) ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V0y_2E0 ) ) ) )
    <=> ? [V4z_2E0: u] :
          ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V3R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V2n ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V4z_2E0 ) ) ) )
          & ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) @ ( app_2E2 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V3R_2E0 ) @ ( s @ A_27a @ V4z_2E0 ) ) ) @ ( s @ A_27a @ V0y_2E0 ) ) ) ) ) ) ).

thf(thm_2Earithmetic_2ENRC__RTC,axiom,
    ! [A_27a: d,V0R_2E0: u,V1n: mono_2Etyop_2Enum_2Enum,V2x_2E0: u,V3y_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V1n ) ) @ ( s @ A_27a @ V2x_2E0 ) @ ( s @ A_27a @ V3y_2E0 ) ) ) )
     => ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2ERTC_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ A_27a @ V2x_2E0 ) @ ( s @ A_27a @ V3y_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ERTC__NRC,axiom,
    ! [A_27a: d,V0R_2E0: u,V1x_2E0: u,V2y_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2ERTC_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) )
     => ? [V3n: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3n ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ERTC__eq__NRC,axiom,
    ! [A_27a: d,V0R_2E0: u,V1x_2E0: u,V2y_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2ERTC_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) )
    <=> ? [V3n: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ V3n ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ETC__eq__NRC,axiom,
    ! [A_27a: d,V0R_2E0: u,V1x_2E0: u,V2y_2E0: u] :
      ( ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Erelation_2ETC_2E3 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) )
    <=> ? [V3n: mono_2Etyop_2Enum_2Enum] : ( j_mono_2Etyop_2Emin_2Ebool @ ( s @ tyop_2Emin_2Ebool @ ( c_2Earithmetic_2ENRC_2E4 @ ( s @ ( tyop_2Emin_2Efun @ A_27a @ ( tyop_2Emin_2Efun @ A_27a @ tyop_2Emin_2Ebool ) ) @ V0R_2E0 ) @ ( s @ tyop_2Enum_2Enum @ ( i_mono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Enum_2ESUC @ V3n ) ) ) @ ( s @ A_27a @ V1x_2E0 ) @ ( s @ A_27a @ V2y_2E0 ) ) ) ) ) ).

thf(thm_2Earithmetic_2ELESS__EQUAL__DIFF,axiom,
    ! [V0m: mono_2Etyop_2Enum_2Enum,V1n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2E_3C_3D @ V0m @ V1n )
     => ? [V2k: mono_2Etyop_2Enum_2Enum] :
          ( V0m
          = ( mono_2Ec_2Earithmetic_2E_2D @ V1n @ V2k ) ) ) ).

thf(thm_2Earithmetic_2EMOD__2,conjecture,
    ! [V0n: mono_2Etyop_2Enum_2Enum] :
      ( ( mono_2Ec_2Earithmetic_2EMOD @ V0n @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT2 @ mono_2Ec_2Earithmetic_2EZERO ) ) )
      = ( mono_2Ec_2Ebool_2ECOND_2Emono_2Etyop_2Enum_2Enum @ ( mono_2Ec_2Earithmetic_2EEVEN @ V0n ) @ mono_2Ec_2Enum_2E0 @ ( mono_2Ec_2Earithmetic_2ENUMERAL @ ( mono_2Ec_2Earithmetic_2EBIT1 @ mono_2Ec_2Earithmetic_2EZERO ) ) ) ) ).

%------------------------------------------------------------------------------
